/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.image;

import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.toolkit.image.ColorMapping;
import at.mrdevelopment.toolkit.image.RawImage;
import at.mrdevelopment.toolkit.image.RawImageFactory;
import at.mrdevelopment.toolkit.image.RawImageType;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class COGImageConversion {
    private static final File INPUT = new File("input.png");
    private static final File OUTPUT = new File("output.png");

    public static void main(String[] args) throws IOException {
        BufferedImage sourceImage = ImageIO.read(INPUT);
        BufferedImage targetImage = COGImageConversion.convertToCogImage(sourceImage, LabelType.BATTERY_270);
        ImageIO.write((RenderedImage)targetImage, "PNG", OUTPUT);
    }

    public static BufferedImage convertToCogImage(BufferedImage sourceImage, LabelType labelType) {
        RawImage rawImage = RawImageFactory.newImage((BufferedImage)sourceImage, (RawImageType)labelType.getRawImageType(), (ColorMapping[])labelType.getColorMappings());
        byte[] data = labelType.getDisplayDriving().toImage(rawImage);
        RawImage convertedImage = RawImageFactory.newImage((int)sourceImage.getWidth(), (int)sourceImage.getHeight(), (byte[])data, (RawImageType)labelType.getRawImageType(), (ColorMapping[])labelType.getColorMappings());
        return convertedImage.toBufferedImage();
    }
}

