/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.hardware;

import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.core.security.Puk;
import at.mrdevelopment.esl.hardware.LabelConfiguration;
import at.mrdevelopment.esl.hardware.TemperatureSensorCalibration;
import at.mrdevelopment.esl.wireless.Address;

public class RawConfiguration {
    private static final int CONFIGURATION_SIZE = 84;
    private static final int ADDRESS_INDEX = 2;
    private static final int TEMP_OFFSET_INDEX = 6;
    private static final int STATUS_BITS_INDEX = 7;
    private static final int POWER_SENSE_INTERVAL_INDEX = 8;
    private static final int POWER_SENSE_BATTERY_LOW_THRESH_INDEX = 9;
    private static final int POWER_SENSE_BATTERY_BAD_THRESH_INDEX = 10;
    private static final int POWER_SENSE_LOW_ACCEPTED_THRESH_INDEX = 11;
    private static final int PIN_INDEX = 16;
    private static final int PUK_INDEX = 32;
    private static final int PSK_INDEX = 48;
    private final Address address;
    private final LabelConfiguration labelConfiguration;
    private final Pin pin;
    private final Puk puk;
    private final Key psk;

    public RawConfiguration(Address address, LabelConfiguration labelConfiguration, Pin pin, Puk puk, Key psk) {
        this.address = address;
        this.labelConfiguration = labelConfiguration;
        this.pin = pin;
        this.puk = puk;
        this.psk = psk;
    }

    public byte[] getConfiguration(double temperature, int adcValue) {
        this.checkRange(adcValue, 0, 4096);
        return this.getConfiguration(TemperatureSensorCalibration.getOffset(temperature, adcValue));
    }

    public byte[] getConfiguration(int tempOffset) {
        this.checkRange(tempOffset, -128, 127);
        byte[] data = new byte[84];
        for (int index = 0; index < data.length; ++index) {
            data[index] = -1;
        }
        byte[] addressBytes = this.address.getSimplicitiAddress();
        data[2] = this.mapToNewAddress(addressBytes[0]);
        data[3] = addressBytes[1];
        data[4] = addressBytes[2];
        data[5] = addressBytes[3];
        data[6] = this.asInt8(tempOffset);
        data[8] = this.asUint8(this.labelConfiguration.getPowerSenseInterval());
        data[9] = this.asUint8(this.labelConfiguration.getBatteryLowThreshold());
        data[10] = this.asUint8(this.labelConfiguration.getBatteryBadThreshold());
        data[11] = this.asUint8(this.labelConfiguration.getBatteryLowAcceptedThreshold());
        if (this.pin != null && this.puk != null && this.psk != null) {
            byte[] pin = this.pin.toBytes();
            byte[] puk = this.puk.toBytes();
            byte[] psk = this.psk.toBytes();
            for (int offset = 0; offset < 16; ++offset) {
                data[16 + offset] = pin[offset];
                data[32 + offset] = puk[offset];
                data[48 + offset] = psk[offset];
            }
            data[7] = -3;
        }
        return data;
    }

    private byte mapToNewAddress(byte addressByte) {
        return addressByte;
    }

    private byte asInt8(int value) {
        this.checkRange(value, -128, 127);
        return (byte)(((value & 0x80) == 128 ? -128 : 0) + (value & 0x7F));
    }

    private byte asUint8(int value) {
        this.checkRange(value, 0, 255);
        return (byte)value;
    }

    private void checkRange(int value, int min, int max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException(String.format("Value must be between %d and %d but is %d", min, max, value));
        }
    }

    public String getConfigurationForTexasInstrumentsFlashProgrammer(int tempOffset) {
        StringBuilder configuration = new StringBuilder();
        for (byte value : this.getConfiguration(tempOffset)) {
            configuration.append(String.format("%02X ", value));
        }
        return configuration.toString().trim();
    }

    public String getConfigurationForTexasInstrumentsConsoleFlashProgrammer(int tempOffset) {
        return this.getConfigurationForTexasInstrumentsFlashProgrammer(tempOffset).replaceAll(" ", ".");
    }
}

