/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.hardware;

import at.mrdevelopment.toolkit.InitializationException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class LabelConfiguration {
    private final int powerSenseInterval;
    private final int batteryLowThreshold;
    private final int batteryBadThreshold;
    private final int batteryLowAcceptedThreshold;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LabelConfiguration(File configFile) throws InitializationException {
        try {
            FileReader fileReader = new FileReader(configFile);
            try {
                Properties properties = new Properties();
                properties.load(fileReader);
                this.powerSenseInterval = Integer.parseInt(properties.getProperty("powerSenseInterval"));
                this.batteryLowThreshold = Integer.parseInt(properties.getProperty("batteryLowThreshold"));
                this.batteryBadThreshold = Integer.parseInt(properties.getProperty("batteryBadThreshold"));
                this.batteryLowAcceptedThreshold = Integer.parseInt(properties.getProperty("batteryLowAcceptedThreshold"));
            }
            finally {
                fileReader.close();
            }
        }
        catch (NumberFormatException exc) {
            throw new InitializationException("Could not parse label configuration file", new Object[0]);
        }
        catch (IOException exc) {
            throw new InitializationException("Could not read label configuration file", new Object[0]);
        }
    }

    public int getPowerSenseInterval() {
        return this.powerSenseInterval;
    }

    public int getBatteryLowThreshold() {
        return this.batteryLowThreshold;
    }

    public int getBatteryBadThreshold() {
        return this.batteryBadThreshold;
    }

    public int getBatteryLowAcceptedThreshold() {
        return this.batteryLowAcceptedThreshold;
    }
}

