/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.validator;

import at.mrdevelopment.esl.gui.validator.HostValidator;
import at.mrdevelopment.esl.gui.validator.HostnameValidator;
import at.mrdevelopment.esl.gui.validator.IPAddressValidator;
import at.mrdevelopment.esl.gui.validator.NetmaskValidator;
import at.mrdevelopment.esl.gui.validator.RangeValidator;
import org.junit.Assert;
import org.junit.Test;

public class ValidatorTest {
    @Test
    public void testIPAddressValidation() {
        IPAddressValidator validator = new IPAddressValidator(false);
        validator.setValue("");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue(null);
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("192.168.1");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("12.12.12.");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("12");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("300.1.1.1");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("127.0.0.1");
        validator.validate();
        validator.printErrors();
        Assert.assertFalse((boolean)validator.hasErrors());
        validator.setValue("192.168.1.12");
        validator.validate();
        validator.printErrors();
        Assert.assertFalse((boolean)validator.hasErrors());
        validator.setValue("");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("192.168.1");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("12.12.12.");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("12");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("300.1.1.1");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
    }

    @Test
    public void testNetmaskValiation() {
        NetmaskValidator validator = new NetmaskValidator(false);
        validator.setValue("");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue(null);
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("255.255.255");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("255.255.255.");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("12");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("192.168.1.12");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("127.0.0.0");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("192.168.1");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("12.12.12.");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("12");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("300.1.1.1");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("192.168.1.12");
        validator.validate();
        validator.printErrors();
        validator.setValue("255.128.255.0");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("0.255.255.0");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("255.255.255.255");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("255.255.255.0");
        validator.validate();
        validator.printErrors();
        Assert.assertFalse((boolean)validator.hasErrors());
        validator.setValue("255.255.128.0");
        validator.validate();
        validator.printErrors();
        Assert.assertFalse((boolean)validator.hasErrors());
        validator.setValue("255.0.255.0");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
    }

    @Test
    public void testIntervalValidation() {
        RangeValidator validator = new RangeValidator(0, 100, false);
        validator.setValue("");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue(null);
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("50");
        validator.validate();
        validator.printErrors();
        Assert.assertFalse((boolean)validator.hasErrors());
        validator.setValue("100");
        validator.validate();
        validator.printErrors();
        Assert.assertFalse((boolean)validator.hasErrors());
        validator.setValue("275");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("-150");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
    }

    @Test
    public void testHostnameValidation() {
        HostnameValidator validator = new HostnameValidator(false);
        validator.setValue(null);
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("**HOST$%&/(NAME**");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("1234567890123456789012345678901234567890123456789012345678901234.1");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("host.");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue(".host");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("host..name");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("imagotag-ap1550");
        validator.validate();
        validator.printErrors();
        Assert.assertFalse((boolean)validator.hasErrors());
        validator.setValue("host.name");
        validator.validate();
        validator.printErrors();
        Assert.assertFalse((boolean)validator.hasErrors());
        validator.setValue("this.host.name.is.valid.but.also.very.very.very.very.very.very.very.very.very.very.yrev.very.very.very.very.very.very.very.very.very.very.very.very.very.very.very.very.very.long.lets.see.if.it.passes.the.junit.test.this.string.can.be.up.to.255.chars.long");
        validator.validate();
        validator.printErrors();
        Assert.assertFalse((boolean)validator.hasErrors());
        validator.setValue("host_name");
        validator.validate();
        validator.printErrors();
        Assert.assertFalse((boolean)validator.hasErrors());
        validator.setValue("host.name_");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("_host.name");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("esl_123_ap");
        validator.validate();
        validator.printErrors();
        Assert.assertFalse((boolean)validator.hasErrors());
    }

    @Test
    public void testHostValidation() {
        HostValidator validator = new HostValidator(false);
        validator.setValue(null);
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
        validator.setValue("imagodev");
        validator.validate();
        validator.printErrors();
        Assert.assertFalse((boolean)validator.hasErrors());
        validator.setValue("192.168.1.212");
        validator.validate();
        validator.printErrors();
        Assert.assertFalse((boolean)validator.hasErrors());
        validator.setValue("192");
        validator.validate();
        validator.printErrors();
        Assert.assertTrue((boolean)validator.hasErrors());
    }
}

