/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.validator;

import at.mrdevelopment.esl.gui.validator.TextValidator;

public class TagValidator
extends TextValidator<String> {
    private static final String TAG_RULE = "([A-Z0-9_])*";

    public TagValidator(boolean allowEmpty) {
        super(allowEmpty);
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getValue() == null || ((String)this.getValue()).isEmpty()) {
            if (!this.isAllowEmpty()) {
                this.addError("Must not be empty");
            }
            return;
        }
        if (this.getValue() == null || ((String)this.getValue()).length() > 30) {
            this.addError("Not a valid tag (name is too long)");
        }
        if (!((String)this.getValue()).matches(TAG_RULE)) {
            this.addError("Not a valid tag (contains invalid symbols)");
        }
    }
}

