/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.validator;

import at.mrdevelopment.esl.gui.validator.TextValidator;

public class RangeValidator
extends TextValidator<String> {
    private final int from;
    private final int to;

    public RangeValidator(int from, int to, boolean allowEmpty) {
        super(allowEmpty);
        this.from = from;
        this.to = to;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getValue() == null || ((String)this.getValue()).isEmpty()) {
            if (!this.isAllowEmpty()) {
                this.addError("Must not be empty");
            }
            return;
        }
        Integer intValue = null;
        try {
            intValue = Integer.parseInt((String)this.getValue());
        }
        catch (NumberFormatException exc) {
            this.addError("Not a valid number");
            return;
        }
        if (intValue < this.from) {
            this.addError(String.format("Value is too small (must be >=%d)", this.from));
        } else if (intValue > this.to) {
            this.addError(String.format("Value is too large (must be <%d)", this.to));
        }
    }
}

