/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.validator;

import at.mrdevelopment.esl.gui.validator.IPAddressValidator;

public class NetmaskValidator
extends IPAddressValidator {
    public NetmaskValidator(boolean allowEmpty) {
        super(allowEmpty);
    }

    @Override
    public void validate() {
        super.validate();
        this.validateSubnetMask();
    }

    private void validateSubnetMask() {
        if (this.getValue() == null || ((String)this.getValue()).isEmpty()) {
            return;
        }
        String[] splittedMask = ((String)this.getValue()).split("\\.");
        String[] permittedValues = new String[]{"128", "192", "224", "240", "248", "252", "254", "255", "0"};
        if (splittedMask.length == 4) {
            int permittedValue = 49;
            boolean firstOccurrence = true;
            for (String currentValue : splittedMask) {
                boolean isValidValue = false;
                for (String currentPermittedValue : permittedValues) {
                    if (!currentPermittedValue.equals(currentValue)) continue;
                    isValidValue = true;
                }
                if (!isValidValue) {
                    this.addError("Not a valid subnet mask");
                    return;
                }
                String currentByte = Integer.toBinaryString(Integer.valueOf(currentValue));
                for (int n : currentByte.toCharArray()) {
                    if (n == permittedValue) continue;
                    if (firstOccurrence) {
                        permittedValue = 48;
                        firstOccurrence = false;
                        continue;
                    }
                    this.addError("Not a valid subnet mask");
                    return;
                }
            }
            if (permittedValue == 49) {
                this.addError("Not a valid subnet mask");
            }
        } else {
            this.addError("Not a valid subnet mask");
        }
    }
}

