/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.validator;

import at.mrdevelopment.esl.gui.validator.TextValidator;
import org.apache.commons.lang.StringUtils;

public class MACValidator
extends TextValidator<String> {
    public MACValidator(boolean allowEmpty) {
        super(allowEmpty);
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getValue() == null || ((String)this.getValue()).isEmpty()) {
            if (!this.isAllowEmpty()) {
                this.addError("Must not be empty");
            }
            return;
        }
        String[] splittedAddress = StringUtils.splitPreserveAllTokens((String)((String)this.getValue()), (String)":");
        if (splittedAddress.length != 6) {
            this.addError("Invalid MAC address");
            return;
        }
        for (String addressPart : splittedAddress) {
            try {
                if (Long.parseLong(addressPart, 16) <= 254L) continue;
                this.addError("Invalid MAC address");
                return;
            }
            catch (NumberFormatException exc) {
                this.addError("Invalid MAC address");
                return;
            }
        }
    }
}

