/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.userinfo;

import at.mrdevelopment.esl.gui.userinfo.ErrorMessage;
import at.mrdevelopment.esl.gui.userinfo.ExceptionMessage;
import at.mrdevelopment.esl.gui.userinfo.InfoMessage;
import at.mrdevelopment.esl.gui.userinfo.WarningMessage;
import at.mrdevelopment.toolkit.gui.AbstractView;
import at.mrdevelopment.toolkit.gui.MouseEventAdapter;
import at.mrdevelopment.toolkit.gui.View;
import at.mrdevelopment.toolkit.userinfo.UserInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class UserInfoView
extends AbstractView
implements UserInfo,
View {
    private final DefaultListModel model = new DefaultListModel();
    private final JList list = new JList(this.model);
    private final JPanel panel;

    public UserInfoView() {
        this(DateTimeFormat.forStyle((String)"-M"), null);
    }

    public UserInfoView(DateTimeFormatter formatter) {
        this(formatter, null);
    }

    public UserInfoView(DateTimeFormatter formatter, Font font) {
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new LabelRenderer(formatter));
        this.list.setFont(font);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add(new JScrollPane(this.list, 22, 30));
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem clearItem = new JMenuItem("Clear");
        popupMenu.add(clearItem);
        clearItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                UserInfoView.this.clear();
            }
        });
        this.list.addMouseListener((MouseListener)new MouseEventAdapter(){

            public void onDoubleClick(MouseEvent event) {
                UserInfoView.this.executeSelectedItem();
            }

            public void onPopupTrigger(MouseEvent event) {
                popupMenu.show(event.getComponent(), event.getX(), event.getY());
            }
        });
    }

    public Component getComponent() {
        return this.panel;
    }

    public String getTitle() {
        return "Messages";
    }

    public void addInfo(String message, Object ... args) {
        this.addMessage(new InfoMessage(message, args));
    }

    public void addWarning(String message, Object ... args) {
        this.addMessage(new WarningMessage(message, args));
    }

    public void addError(String message, Object ... args) {
        this.addMessage(new ErrorMessage(message, args));
    }

    public void addException(Throwable exc) {
        this.addMessage(new ExceptionMessage(exc));
    }

    public void addException(String message, Throwable exc) {
        this.addMessage(new ExceptionMessage(message, exc));
    }

    public void clear() {
        this.model.clear();
    }

    private void executeSelectedItem() {
        InfoMessage infoMessage = (InfoMessage)this.list.getSelectedValue();
        if (infoMessage != null) {
            infoMessage.execute();
        }
    }

    private void addMessage(final InfoMessage message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UserInfoView.this.dispatchMessage(message);
            }
        });
    }

    private void dispatchMessage(InfoMessage message) {
        if (message != null && !message.isEmpty()) {
            this.model.add(0, message);
            if (this.model.getSize() > 1500) {
                this.model.removeRange(1000, this.model.getSize() - 1);
            }
            this.notifyActivated();
        }
    }

    private static class LabelRenderer
    extends DefaultListCellRenderer {
        private final DateTimeFormatter formatter;

        public LabelRenderer(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            InfoMessage message = (InfoMessage)value;
            message.formatLabel(this, isSelected, this.formatter);
            return this;
        }
    }
}

