/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.editor;

import at.mrdevelopment.esl.gui.editor.TextEditor;
import at.mrdevelopment.toolkit.Version;

public class VersionEditor
extends TextEditor<Version> {
    private Version version;

    @Override
    public Version getValue() {
        return this.version;
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            try {
                this.setEditorText(Version.fromString((String)value.toString()).getVersionString());
            }
            catch (NumberFormatException exc) {
                this.version = null;
            }
            catch (IllegalArgumentException exc) {
                this.version = null;
            }
        }
    }

    @Override
    public void validate() {
        super.validate();
        String value = this.getEditorText();
        if (!this.canBeNull() && value.isEmpty()) {
            this.addError("Field is empty");
        } else if (value.isEmpty()) {
            this.version = null;
        } else {
            try {
                this.version = Version.fromString((String)value);
            }
            catch (NumberFormatException exc) {
                this.addError("Version not valid");
                this.version = null;
            }
            catch (IllegalArgumentException exc) {
                this.addError("Version not valid");
                this.version = null;
            }
        }
    }
}

