/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.editor;

import at.mrdevelopment.esl.gui.editor.TextEditor;
import at.mrdevelopment.toolkit.security.Password;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import javax.swing.JPasswordField;

public class PasswordEditor
extends TextEditor<String> {
    private PasswordEditor verifyEditorFor;
    private Password password;

    public PasswordEditor() {
        super(new JPasswordField("", 20));
    }

    public String getPassword() {
        JPasswordField passwordField = (JPasswordField)this.getEditorComponent();
        return new String(passwordField.getPassword());
    }

    public String getSaltedHash() {
        try {
            Password password = Password.createFromPlainPassword((String)this.getPassword());
            return password.getSaltedHash();
        }
        catch (NoSuchAlgorithmException exc) {
            throw new RuntimeException(exc);
        }
        catch (UnsupportedEncodingException exc) {
            throw new RuntimeException(exc);
        }
    }

    public void setPasswordHash(String passwordHash) {
        this.password = new Password(passwordHash);
    }

    public void setAsVerifyFieldFor(PasswordEditor passwordEditor) {
        this.verifyEditorFor = passwordEditor;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.password != null) {
            this.validatePassword();
        }
        if (this.verifyEditorFor != null) {
            this.validatePasswordVerify();
        }
    }

    private void validatePassword() {
        try {
            if (!this.password.verify(this.getPassword())) {
                this.addError("Wrong password");
            }
        }
        catch (NoSuchAlgorithmException exc) {
            this.addError("Password algorithm not supported");
        }
        catch (UnsupportedEncodingException exc) {
            this.addError("Encoding not supported");
        }
    }

    private void validatePasswordVerify() {
        if (!this.getPassword().equals(this.verifyEditorFor.getPassword())) {
            this.addError("Does not match password");
        }
    }

    @Override
    public String getValue() {
        return this.getSaltedHash();
    }
}

