/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.editor;

import at.mrdevelopment.esl.gui.editor.TextEditor;

public class IntegerEditor
extends TextEditor<Integer> {
    private final int minValue;
    private final int maxValue;
    private Integer integerValue;

    public IntegerEditor() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerEditor(int minValue, int maxValue) {
        if (minValue >= maxValue) {
            throw new IllegalArgumentException();
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            this.setEditorText(Integer.toString((Integer)value));
        }
    }

    @Override
    public Integer getValue() {
        return this.integerValue;
    }

    @Override
    public void validate() {
        super.validate();
        String value = this.getEditorText();
        if (!this.canBeNull() && value.isEmpty()) {
            this.addError("Field is empty");
        } else if (value.isEmpty()) {
            this.integerValue = null;
        } else {
            try {
                this.integerValue = Integer.parseInt(value);
                if (this.integerValue < this.minValue) {
                    this.addError(String.format("Value too small (must be at least %d)", this.minValue));
                } else if (this.integerValue > this.maxValue) {
                    this.addError(String.format("Value too big (must not exceed %d)", this.maxValue));
                }
            }
            catch (NumberFormatException exc) {
                this.addError("Not a valid integer value");
            }
        }
    }
}

