/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.editor;

import at.mrdevelopment.esl.gui.editor.StringEditor;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;

public class HexEditor
extends StringEditor {
    private final int maxLength;

    public HexEditor(JTextComponent textComponent, boolean canBeNull, int maxLength) {
        super(textComponent, canBeNull);
        this.maxLength = maxLength;
    }

    public HexEditor(boolean canBeNull, int maxLength) {
        super(canBeNull);
        this.maxLength = maxLength;
    }

    public HexEditor() {
        super(true);
        this.maxLength = Integer.MAX_VALUE;
    }

    @Override
    public void validate() {
        super.validate();
        if (!this.hasErrors()) {
            try {
                String value = this.getEditorText();
                if (value.length() > this.maxLength) {
                    this.addError("Input exceeds maximum length");
                    return;
                }
                value = StringUtils.trim((String)value.replaceAll("\r", "").replaceAll("\n", ""));
                for (int index = 0; index < value.length(); ++index) {
                    Integer.parseInt(Character.toString(value.charAt(index)), 16);
                }
            }
            catch (NumberFormatException exc) {
                this.addError("Not a valid hex number");
            }
        }
    }

    @Override
    public String getValue() {
        String value = super.getValue();
        return value != null ? StringUtils.trim((String)value.replaceAll("\r", "").replaceAll("\n", "")) : null;
    }
}

