/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.editor;

import at.mrdevelopment.esl.gui.editor.TextEditor;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public abstract class ForceUppercaseTextEditor<T>
extends TextEditor<T> {
    public ForceUppercaseTextEditor() {
        this.setUppercaseFilter();
    }

    public ForceUppercaseTextEditor(int length) {
        super(length);
        this.setUppercaseFilter();
    }

    private void setUppercaseFilter() {
        UppercaseDocumentFilter filter = new UppercaseDocumentFilter();
        JTextField textField = (JTextField)this.getEditorComponent();
        AbstractDocument document = (AbstractDocument)textField.getDocument();
        document.setDocumentFilter(filter);
    }

    private class UppercaseDocumentFilter
    extends DocumentFilter {
        private UppercaseDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attrs) throws BadLocationException {
            fb.insertString(offset, text != null ? this.convert(text) : null, attrs);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            fb.replace(offset, length, text != null ? this.convert(text) : null, attrs);
        }

        private String convert(String input) {
            return input.replace('-', '_').replace(' ', '_').toUpperCase();
        }
    }
}

