/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.editor;

import at.mrdevelopment.esl.gui.editor.TextEditor;

public class FloatEditor
extends TextEditor<Float> {
    private final float minValue;
    private final float maxValue;
    private Float floatValue;

    public FloatEditor() {
        this(Float.MIN_VALUE, Float.MAX_VALUE);
    }

    public FloatEditor(float minValue, float maxValue) {
        if (minValue >= maxValue) {
            throw new IllegalArgumentException();
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            this.setEditorText(Float.toString(((Float)value).floatValue()));
        }
    }

    @Override
    public Float getValue() {
        return this.floatValue;
    }

    @Override
    public void validate() {
        super.validate();
        String value = this.getEditorText();
        if (!this.canBeNull() && value.isEmpty()) {
            this.addError("Field is empty");
        } else if (value.isEmpty()) {
            this.floatValue = null;
        } else {
            try {
                this.floatValue = Float.valueOf(Float.parseFloat(value));
                if (this.floatValue.floatValue() < this.minValue) {
                    this.addError(String.format("Value too small (must be at least %f)", Float.valueOf(this.minValue)));
                } else if (this.floatValue.floatValue() > this.maxValue) {
                    this.addError(String.format("Value too big (must not exceed %f)", Float.valueOf(this.maxValue)));
                }
            }
            catch (NumberFormatException exc) {
                this.addError("Not a valid float value");
            }
        }
    }
}

