/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.editor;

import at.mrdevelopment.esl.gui.editor.AbstractFormEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public abstract class EnumEditor<E extends Enum<E>>
extends AbstractFormEditor<E> {
    protected JComboBox editorComponent = new JComboBox();
    protected Class<E> enumClass;

    public EnumEditor(Class<E> enumClass) {
        this.enumClass = enumClass;
        for (Enum value : (Enum[])enumClass.getEnumConstants()) {
            this.editorComponent.addItem(value);
        }
    }

    @Override
    public JComponent getEditorComponent() {
        return this.editorComponent;
    }

    @Override
    public abstract void setValue(Object var1);

    @Override
    public void setCanBeNull(boolean canBeNull) {
        super.setCanBeNull(canBeNull);
        if (canBeNull) {
            this.editorComponent.addItem(null);
        }
    }

    @Override
    public void validate() {
        super.validate();
        if (!this.canBeNull() && this.editorComponent.getSelectedIndex() == -1) {
            this.addError("No entry selected");
        }
    }

    @Override
    public E getValue() {
        return (E)((Enum)this.enumClass.cast(this.editorComponent.getSelectedItem()));
    }

    protected void setEditorValue(E value) {
        this.editorComponent.setSelectedItem(value);
    }
}

