/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.editor;

import at.mrdevelopment.esl.gui.editor.TextEditor;
import at.mrdevelopment.esl.gui.validator.HostValidator;
import at.mrdevelopment.esl.gui.validator.PortValidator;
import org.apache.commons.lang.StringUtils;

public class AddressEditor
extends TextEditor<String> {
    @Override
    public String getValue() {
        return this.getEditorText();
    }

    @Override
    public void validate() {
        super.validate();
        String[] splitted = StringUtils.splitPreserveAllTokens((String)this.getEditorText(), (String)":");
        if (splitted.length == 1) {
            this.validateHost(splitted[0]);
        } else if (splitted.length == 2) {
            this.validateHost(splitted[0]);
            this.validatePort(splitted[1]);
        } else if (this.canBeNull()) {
            if (StringUtils.isNotBlank((String)this.getEditorText())) {
                this.addError("Not a valid host");
            }
        } else {
            this.addError("Not a valid host");
        }
    }

    private void validateHost(String host) {
        HostValidator validator = new HostValidator(this.canBeNull());
        validator.setValue(host);
        validator.validate();
        for (String error : validator.getErrors()) {
            this.addError(error);
        }
    }

    private void validatePort(String port) {
        PortValidator validator = new PortValidator(this.canBeNull());
        validator.setValue(port);
        validator.validate();
        for (String error : validator.getErrors()) {
            this.addError(error);
        }
    }
}

