/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.type.UpdateError;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class UpdateErrorTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Color ERROR_BACKGROUND_COLOR = Color.WHITE;
    private static final Color ERROR_TEXT_COLOR = Color.RED;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        UpdateError updateError = (UpdateError)((Object)value);
        this.setText(this.getErrorText(updateError));
        this.setHorizontalAlignment(0);
        this.setToolTipText(this.getErrorDescription(updateError));
        if (!isSelected) {
            if (updateError != null) {
                this.setForeground(ERROR_TEXT_COLOR);
                this.setBackground(ERROR_BACKGROUND_COLOR);
            } else {
                this.setForeground(Color.BLACK);
                this.setBackground(Color.WHITE);
            }
        }
        return this;
    }

    private String getErrorText(UpdateError updateError) {
        return updateError != null ? String.format("%02d", updateError.getCode()) : "-";
    }

    private String getErrorDescription(UpdateError updateError) {
        return updateError != null ? String.format("%s (Error code %d)", updateError.getDescription(), updateError.getCode()) : "No error";
    }
}

