/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.core.LinkQuality;
import at.mrdevelopment.esl.core.SyncQuality;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.WakeupProfile;
import at.mrdevelopment.esl.wireless.WakeupProfileMapping;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class SyncQualityTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Color GOOD_TEXT_COLOR = new Color(15, 127, 15);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        if (value != null) {
            SyncQuality syncQuality = (SyncQuality)value;
            LinkQuality qualityLevel = syncQuality.getSyncQualityLevel();
            this.setText(qualityLevel.toString());
            this.setHorizontalAlignment(0);
            this.setToolTipText(this.getSyncQualityText(syncQuality, table, row));
            if (!isSelected) {
                if (qualityLevel == LinkQuality.PERFECT || qualityLevel == LinkQuality.GOOD) {
                    this.setForeground(GOOD_TEXT_COLOR);
                } else if (qualityLevel == LinkQuality.AVERAGE) {
                    this.setForeground(Color.ORANGE);
                } else {
                    this.setForeground(Color.RED);
                }
            }
        } else {
            this.setToolTipText(null);
        }
        return this;
    }

    private WakeupProfile getWakeupProfile(JTable table, int row) {
        for (int columnIndex = 0; columnIndex < table.getColumnCount(); ++columnIndex) {
            Object value;
            Class<?> columnClass = table.getColumnClass(columnIndex);
            Address address = null;
            if (columnClass == Address.class) {
                address = (Address)table.getModel().getValueAt(table.convertRowIndexToModel(row), columnIndex);
            } else if (columnClass != String.class && (value = table.getModel().getValueAt(table.convertRowIndexToModel(row), columnIndex)) != null) {
                try {
                    address = Address.fromString(value.toString());
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
            if (address == null) continue;
            WakeupProfileMapping wakeupProfileMapping = WakeupProfileMapping.forAddress(address);
            return wakeupProfileMapping.getRealWakeupProfile(WakeupProfile.NORMAL);
        }
        return null;
    }

    private String getSyncQualityText(SyncQuality syncQuality, JTable table, int row) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        builder.append("Continuous sync time: ");
        builder.append(syncQuality.getContinuousSyncTimeString(this.getWakeupProfile(table, row)));
        builder.append("<br>");
        builder.append("Sync RSSI level: ");
        builder.append((Object)syncQuality.getSyncRssiLevel());
        builder.append("<br>");
        builder.append("Sync LQI level: ");
        builder.append((Object)syncQuality.getSyncLqiLevel());
        builder.append("</html>");
        return builder.toString();
    }
}

