/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.core.Status;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class StatusTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Color SUCCESSFUL_BACKGROUND_COLOR = new Color(91, 255, 91);
    private static final Color FAILED_BACKGROUND_COLOR = new Color(255, 91, 91);
    private static final Color REPLACED_BACKGROUND_COLOR = new Color(195, 255, 195);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        if (value != null) {
            Status status = (Status)((Object)value);
            this.setText(status.toString());
            this.setHorizontalAlignment(0);
            this.setToolTipText(status.getDescription());
            if (!isSelected) {
                if (status.isSuccessful()) {
                    this.setForeground(Color.BLACK);
                    this.setBackground(SUCCESSFUL_BACKGROUND_COLOR);
                } else if (status.isFailed()) {
                    this.setForeground(Color.WHITE);
                    this.setBackground(FAILED_BACKGROUND_COLOR);
                } else if (status.isUnsuccessful()) {
                    this.setForeground(Color.WHITE);
                    this.setBackground(Color.RED);
                } else if (status.isReplaced()) {
                    this.setForeground(Color.BLACK);
                    this.setBackground(REPLACED_BACKGROUND_COLOR);
                } else if (status.isCanceled()) {
                    this.setForeground(Color.BLACK);
                    this.setBackground(Color.LIGHT_GRAY);
                } else if (status.isDelayed()) {
                    this.setForeground(Color.BLACK);
                    this.setBackground(Color.ORANGE);
                } else {
                    this.setForeground(Color.BLACK);
                    this.setBackground(Color.CYAN);
                }
            }
        } else {
            if (!isSelected) {
                this.setForeground(Color.BLACK);
                this.setBackground(Color.WHITE);
            }
            this.setText("");
        }
        return this;
    }
}

