/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.Pair;
import at.mrdevelopment.esl.core.ServiceStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class ServiceStatusTableModel
extends AbstractTableModel {
    private final List<Pair<String, String>> values = new ArrayList<Pair<String, String>>();

    public ServiceStatusTableModel(ServiceStatus serviceStatus) {
        this.update(serviceStatus);
    }

    public synchronized void update(ServiceStatus serviceStatus) {
        if (serviceStatus != null) {
            int previousEntries = this.values.size();
            Map<String, String> properties = serviceStatus.getProperties();
            this.values.clear();
            for (String name : properties.keySet()) {
                this.values.add((Pair<String, String>)new Pair((Object)name, (Object)properties.get(name)));
            }
            if (previousEntries == this.values.size()) {
                this.fireTableRowsUpdated(0, this.values.size() - 1);
            } else {
                this.fireTableDataChanged();
            }
        }
    }

    @Override
    public synchronized int getRowCount() {
        return this.values.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        return columnIndex == 0 ? (String)this.values.get(rowIndex).getFirst() : (String)this.values.get(rowIndex).getSecond();
    }

    @Override
    public synchronized String getColumnName(int columnIndex) {
        return columnIndex == 0 ? "Name" : "Value";
    }
}

