/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.core.SecurityStatus;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class SecurityStatusTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Color ENCRYPTED_TEXT_COLOR = new Color(15, 127, 15);
    private static final Color ENCRYPTED_BACKGROUND_COLOR = Color.WHITE;
    private static final Color UNENCRYPTED_TEXT_COLOR = Color.BLACK;
    private static final Color UNENCRYPTED_BACKGROUND_COLOR = Color.ORANGE;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        if (value != null) {
            SecurityStatus status = (SecurityStatus)((Object)value);
            this.setHorizontalAlignment(0);
            this.setToolTipText(status.getDescription());
            if (status == SecurityStatus.AES128) {
                this.setText("AES");
            } else if (status == SecurityStatus.KEY_UNSET) {
                this.setText("Key unset");
            } else if (status == SecurityStatus.NO_PIN) {
                this.setText("No PIN");
            } else if (status == SecurityStatus.UNSUPPORTED) {
                this.setText("Unsupported");
            } else {
                this.setText("Unknown");
            }
            if (!isSelected) {
                if (status.isEncrypted()) {
                    this.setForeground(ENCRYPTED_TEXT_COLOR);
                    this.setBackground(ENCRYPTED_BACKGROUND_COLOR);
                } else {
                    this.setForeground(UNENCRYPTED_TEXT_COLOR);
                    this.setBackground(UNENCRYPTED_BACKGROUND_COLOR);
                }
            }
        } else if (!isSelected) {
            this.setForeground(Color.BLACK);
            this.setBackground(Color.WHITE);
        }
        return this;
    }
}

