/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.core.PowerStatus;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class PowerStatusTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Color GOOD_TEXT_COLOR = new Color(15, 127, 15);
    private static final Color LOW_TEXT_COLOR = Color.RED;
    private static final Color UNKNOWN_TEXT_COLOR = Color.GRAY;
    private static final Color BAD_TEXT_COLOR = Color.WHITE;
    private static final Color BAD_BACKGROUND_COLOR = new Color(255, 91, 91);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        if (value != null) {
            PowerStatus powerStatus = (PowerStatus)((Object)value);
            this.setText(powerStatus.toString());
            this.setHorizontalAlignment(0);
            this.setToolTipText(powerStatus.getDescription());
            if (!isSelected) {
                if (powerStatus.isGood()) {
                    this.setForeground(GOOD_TEXT_COLOR);
                    this.setBackground(Color.WHITE);
                } else if (powerStatus.isLow()) {
                    this.setForeground(LOW_TEXT_COLOR);
                    this.setBackground(Color.WHITE);
                } else if (powerStatus.isUnknown()) {
                    this.setForeground(UNKNOWN_TEXT_COLOR);
                    this.setBackground(Color.WHITE);
                } else {
                    this.setForeground(BAD_TEXT_COLOR);
                    this.setBackground(BAD_BACKGROUND_COLOR);
                }
            }
        } else if (!isSelected) {
            this.setForeground(Color.BLACK);
            this.setBackground(Color.WHITE);
        }
        return this;
    }
}

