/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.toolkit.datetime.ReadableTimeFormatter;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeTableCellRenderer
extends DefaultTableCellRenderer {
    private final DateTimeFormatter formatter = DateTimeFormat.forStyle((String)"MM");

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        if (value != null) {
            DateTime dateTime = (DateTime)value;
            this.setText(this.formatter.print((ReadableInstant)dateTime));
            this.setHorizontalAlignment(0);
            this.setToolTipText(ReadableTimeFormatter.printMostSignificantElapsedTime((ReadableInstant)dateTime) + " ago");
        } else {
            this.setToolTipText(null);
        }
        return this;
    }
}

