/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.core.ConnectionStatus;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ConnectionStatusTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Color ONLINE_BACKGROUND_COLOR = new Color(91, 255, 91);
    private static final Color OFFLINE_BACKGROUND_COLOR = new Color(255, 91, 91);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        if (value != null) {
            ConnectionStatus status = (ConnectionStatus)((Object)value);
            this.setText(status.toString());
            this.setHorizontalAlignment(0);
            if (!isSelected) {
                if (status.isOnline()) {
                    this.setForeground(Color.BLACK);
                    this.setBackground(ONLINE_BACKGROUND_COLOR);
                } else if (status.isOffline()) {
                    this.setForeground(Color.WHITE);
                    this.setBackground(OFFLINE_BACKGROUND_COLOR);
                } else {
                    this.setForeground(Color.BLACK);
                    this.setBackground(Color.CYAN);
                }
            }
        }
        return this;
    }
}

