/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.gui.ESLFrame;
import at.mrdevelopment.esl.gui.IconListCellRenderer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.gui.GUIUtils;
import at.mrdevelopment.toolkit.gui.IconUtils;
import at.mrdevelopment.toolkit.gui.MouseEventAdapter;
import at.mrdevelopment.toolkit.info.Info;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.Arrays;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;

public class ApplicationStarter {
    private final Map<String, Class<?>> applications;
    private final Map<String, String> applicationDescriptions;
    private JFrame frame;
    private JList applicationBox;
    private JTextField parameterTextArea;
    private JLabel descriptionLabel;

    public ApplicationStarter(String title, Map<String, Class<?>> applications, String[] args) {
        this(title, applications, null, args);
    }

    public ApplicationStarter(String title, Map<String, Class<?>> applications, Map<String, String> applicationDescriptions, String[] args) {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        TeeStream teeStdOut = new TeeStream(System.out, ps);
        System.setOut(teeStdOut);
        TeeStream teeStdErr = new TeeStream(System.err, ps);
        System.setErr(teeStdErr);
        System.setSecurityManager(new SecurityManager(){
            private final SecurityManager parent = System.getSecurityManager();

            @Override
            public void checkPermission(Permission perm) {
                if (this.parent != null) {
                    this.parent.checkPermission(perm);
                }
            }

            @Override
            public void checkExit(int status) {
                if (status > 0) {
                    JOptionPane.showMessageDialog(null, ApplicationStarter.this.getFirstLines(baos.toString(), 5), "Error starting application", 0);
                    StreamUtils.close((OutputStream)baos);
                }
            }
        });
        this.applications = applications;
        this.applicationDescriptions = applicationDescriptions;
        if (args == null || args.length < 1) {
            GUIUtils.setSystemLookAndFeel();
            this.showFrame(title);
        } else {
            String[] arguments = new String[]{};
            String application = args[0];
            if (args.length > 1) {
                arguments = new String[args.length - 1];
                for (int i = 1; i < args.length; ++i) {
                    arguments[i - 1] = args[i];
                }
            }
            try {
                this.startApplication(application, arguments);
            }
            catch (InitializationException exc) {
                exc.printStackTrace();
                System.exit(1);
            }
        }
    }

    protected String getFirstLines(String string, int numberOfLines) {
        String[] splitted = string.split("[\\r\\n]+");
        StringBuilder builder = new StringBuilder();
        int length = splitted.length < numberOfLines ? splitted.length : numberOfLines;
        for (int index = 0; index < length; ++index) {
            builder.append(splitted[index]);
            if (index >= length - 1) continue;
            builder.append(System.getProperty("line.separator"));
        }
        return builder.toString();
    }

    private void startApplication(String application, String[] arguments) throws InitializationException {
        try {
            Class<?> applicationClass = null;
            if (this.applications.containsKey(application)) {
                applicationClass = this.applications.get(application);
            } else {
                applicationClass = Class.forName(application);
                if (!this.applications.containsValue(applicationClass)) {
                    throw new InitializationException("No application known with the name %s", new Object[]{application});
                }
            }
            Method mainMethod = applicationClass.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{arguments});
        }
        catch (ClassNotFoundException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (SecurityException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (NoSuchMethodException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (IllegalArgumentException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (IllegalAccessException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (InvocationTargetException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    private void showFrame(String title) {
        this.frame = new ESLFrame(IconUtils.loadApplicationIcons((String)title));
        try {
            Info info = Info.load(ApplicationStarter.class);
            title = String.format("%s - %s (%d)", title, info.getVersion().getVersionString(), info.getVersion().getBuild());
        }
        catch (SerializeException exc) {
        }
        catch (InitializationException exc) {
            // empty catch block
        }
        this.frame.setTitle(title);
        this.frame.setLayout(new BorderLayout());
        Object[] applicationNames = this.applications.keySet().toArray(new String[this.applications.size()]);
        Arrays.sort(applicationNames);
        this.applicationBox = new JList<Object>(applicationNames);
        this.applicationBox.setLayoutOrientation(2);
        this.applicationBox.setCellRenderer(new IconListCellRenderer());
        this.applicationBox.setSelectionMode(0);
        this.applicationBox.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.applicationBox.setVisibleRowCount((int)Math.ceil((float)applicationNames.length / 4.0f));
        this.applicationBox.addMouseListener((MouseListener)new MouseEventAdapter(){

            public void onDoubleClick(MouseEvent event) {
                ApplicationStarter.this.onStartApplicationButton();
            }
        });
        this.applicationBox.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ApplicationStarter.this.onListSelectionChanged();
            }
        });
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 0, 2), BorderFactory.createTitledBorder("Choose application:")));
        topPanel.add((Component)new JScrollPane(this.applicationBox), "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 0, 2), BorderFactory.createTitledBorder("Description:")));
        this.descriptionLabel = new JLabel(" ");
        JPanel descriptionPanel = new JPanel(new FlowLayout(3, 10, 10));
        descriptionPanel.add(this.descriptionLabel);
        centerPanel.add(descriptionPanel);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        this.parameterTextArea = new JTextField(30);
        this.parameterTextArea.setFont(new Font("Arial", 0, 12));
        JScrollPane scrollPane = new JScrollPane(this.parameterTextArea);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 0, 2), BorderFactory.createTitledBorder("Command line arguments:")));
        bottomPanel.add((Component)scrollPane, "North");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton startButton = new JButton("Start");
        startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ApplicationStarter.this.onStartApplicationButton();
            }
        });
        buttonPanel.add(startButton);
        bottomPanel.add((Component)buttonPanel, "South");
        this.frame.add((Component)topPanel, "North");
        this.frame.add((Component)centerPanel, "Center");
        this.frame.add((Component)bottomPanel, "South");
        this.frame.setDefaultCloseOperation(3);
        this.frame.getRootPane().setDefaultButton(startButton);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationStarter.this.applicationBox.revalidate();
                ApplicationStarter.this.frame.pack();
            }
        });
    }

    protected void onListSelectionChanged() {
        this.updateDescription();
    }

    private void updateDescription() {
        if (this.applicationDescriptions != null && this.applicationBox.getSelectedIndex() >= 0) {
            final String applicationName = this.applicationBox.getSelectedValue().toString();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ApplicationStarter.this.applicationDescriptions.containsKey(applicationName)) {
                        ApplicationStarter.this.descriptionLabel.setText(ApplicationStarter.this.getDescriptionText((String)ApplicationStarter.this.applicationDescriptions.get(applicationName)));
                    } else {
                        ApplicationStarter.this.descriptionLabel.setText("");
                    }
                    ApplicationStarter.this.frame.pack();
                }
            });
        }
    }

    protected String getDescriptionText(String input) {
        StringBuilder builder = new StringBuilder("<html><body><p>");
        builder.append(input);
        builder.append("</p></body></html>");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onStartApplicationButton() {
        try {
            this.frame.setVisible(false);
            this.startApplication((String)this.applicationBox.getSelectedValue(), this.getArgumentsFromTextArea());
        }
        catch (Exception exc) {
            if (exc.getCause() != null && exc.getCause() instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)exc.getCause()).getTargetException();
                JOptionPane.showMessageDialog(this.frame, targetException.getMessage(), "Error starting application", 0);
            } else {
                JOptionPane.showMessageDialog(this.frame, exc.getMessage(), "Error starting application", 0);
            }
        }
        finally {
            this.frame.dispose();
        }
    }

    private String[] getArgumentsFromTextArea() {
        String[] parameters = new String[]{};
        if (this.parameterTextArea.getText() != null) {
            parameters = StringUtils.split((String)this.parameterTextArea.getText(), (String)" ");
        }
        return parameters;
    }

    private class TeeStream
    extends PrintStream {
        final PrintStream out;

        public TeeStream(PrintStream out1, PrintStream out2) {
            super(out1);
            this.out = out2;
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            super.write(buf, off, len);
            this.out.write(buf, off, len);
        }

        @Override
        public void flush() {
            super.flush();
            this.out.flush();
        }
    }
}

