/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.security;

import at.mrdevelopment.esl.core.security.InitializationVector;
import at.mrdevelopment.esl.core.security.Key;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class StreamEncryptionCipher {
    static ESLLogger logger = ESLLogger.getLogger(StreamEncryptionCipher.class);
    private final Cipher cipher;

    public StreamEncryptionCipher(Key key, InitializationVector iv, CipherMode cipherMode) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.toBytes(), "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv.toBytes());
            this.cipher = Cipher.getInstance("AES/CBC/NoPadding");
            this.cipher.init(cipherMode.getOpMode(), (java.security.Key)secretKeySpec, ivParameterSpec);
        }
        catch (GeneralSecurityException exc) {
            throw new RuntimeException(exc);
        }
    }

    public byte[] update(byte[] data, boolean isFinal) {
        try {
            byte[] result = isFinal ? this.cipher.doFinal(data) : this.cipher.update(data);
            logger.warn("dataLength=%d, cypheredDataLength=%d", new Object[]{data.length, result.length});
            return result;
        }
        catch (GeneralSecurityException exc) {
            throw new RuntimeException();
        }
    }

    public static enum CipherMode {
        ENCRYPT_MODE{

            @Override
            public int getOpMode() {
                return 1;
            }
        }
        ,
        DECRYPT_MODE{

            @Override
            public int getOpMode() {
                return 2;
            }
        };


        protected abstract int getOpMode();
    }
}

