/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.security;

import at.mrdevelopment.esl.core.security.Puk;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class Pin {
    private static final int PIN_LENGTH = 3;
    private static final int EXTENDED_PIN_LENGTH = 16;
    private final byte[] code;

    public static Pin fromPuk(Puk puk) {
        return new Pin(Arrays.copyOf(DigestUtils.sha256((byte[])puk.toBytes()), 3));
    }

    public static Pin fromBase64(String pin) {
        return new Pin(Arrays.copyOf(new Base64(0).decode(pin), 3));
    }

    public static Pin fromHexString(String pinString) {
        long pin = Long.parseLong(pinString, 16);
        return Pin.fromLong(pin);
    }

    public static Pin fromLong(long pin) {
        byte[] code = new byte[3];
        code[2] = (byte)((pin & 0xFFL) >> 0);
        code[1] = (byte)((pin & 0xFF00L) >> 8);
        code[0] = (byte)((pin & 0xFF0000L) >> 16);
        return new Pin(code);
    }

    public static Pin from128BitHexString(String pinString) {
        return new Pin(Arrays.copyOf(Pin.getBytesFromHexString(pinString), 16));
    }

    private static byte[] getBytesFromHexString(String pin) {
        byte[] pinBytes = new byte[pin.length() / 2];
        for (int index = 0; index < pin.length(); index += 2) {
            pinBytes[index / 2] = (byte)((Character.digit(pin.charAt(index), 16) << 4) + Character.digit(pin.charAt(index + 1), 16));
        }
        return pinBytes;
    }

    public static Pin fromBytes(byte[] bytes) {
        return new Pin(Arrays.copyOf(bytes, 3));
    }

    private Pin(byte[] code) {
        this.code = code;
    }

    public String toBase64() {
        return new Base64(0).encodeToString(this.code);
    }

    public long toLong() {
        return ((long)this.code[2] & 0xFFL) << 0 | ((long)this.code[1] & 0xFFL) << 8 | ((long)this.code[0] & 0xFFL) << 16;
    }

    public String toHex() {
        return String.format("%08x", this.toLong());
    }

    public byte[] toBytes() {
        return this.code;
    }

    public String toString() {
        return this.toBase64();
    }
}

