/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.security;

import at.mrdevelopment.esl.core.security.Nonce;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Test;

public class NonceTest {
    @Test
    public void deriveIncremented() {
        String hexString = "0123456789abcdef0123456789abcdef";
        String incrementedHexString = "0123456789abcdef0123456789abcdf0";
        Nonce nonce = Nonce.fromHexString(hexString);
        Nonce incremented = Nonce.deriveIncremented(nonce);
        Assert.assertEquals((Object)new BigInteger(hexString, 16), (Object)nonce.toBigInteger());
        Assert.assertEquals((Object)new BigInteger(incrementedHexString, 16), (Object)incremented.toBigInteger());
    }

    @Test
    public void deriveIncrementedOverflow() {
        String hexString = "ffffffffffffffffffffffffffffffff";
        Nonce nonce = Nonce.fromHexString(hexString);
        Nonce incremented = Nonce.deriveIncremented(nonce);
        Assert.assertEquals((Object)BigInteger.valueOf(-1L), (Object)nonce.toBigInteger());
        Assert.assertEquals((Object)BigInteger.ZERO, (Object)incremented.toBigInteger());
    }
}

