/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.security;

import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.core.security.Puk;
import at.mrdevelopment.esl.wireless.Address;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;

public class Key {
    public static final int KEY_LENGTH = 16;
    private static Key EMPTY_KEY = new Key(new byte[16]);
    private final byte[] bytes;

    public static Key emptyKey() {
        return EMPTY_KEY;
    }

    public static Key generateRandomKey(Random random) {
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        return new Key(bytes);
    }

    public static Key generateFromPassphrase(String passphrase) {
        return new Key(Arrays.copyOf(DigestUtils.sha256((String)passphrase), 16));
    }

    public static Key deriveFromKeyAndAddress(Key key, Address address) {
        return new Key(Arrays.copyOf(DigestUtils.sha256((String)(key.toBase64() + address.toString())), 16));
    }

    public static Key deriveFromKeyAndPin(Key key, Pin pin) {
        byte[] bytes = new byte[16];
        byte[] keyBytes = key.toBytes();
        byte[] pinBytes = ArrayUtils.add((byte[])pin.toBytes(), (int)0, (byte)0);
        for (int index = 0; index < 16; ++index) {
            bytes[index] = (byte)(keyBytes[index] ^ pinBytes[index % 4]);
        }
        return new Key(bytes);
    }

    public static Key deriveFromPuk(Puk puk) {
        return new Key(Arrays.copyOf(puk.toBytes(), 16));
    }

    public static Key fromBase64(String key) {
        return new Key(Arrays.copyOf(new Base64(0).decode(key), 16));
    }

    public static Key fromBytes(byte[] bytes) {
        return new Key(Arrays.copyOf(bytes, 16));
    }

    public static Key fromHexString(String keyString) {
        return new Key(Arrays.copyOf(Key.getBytesFromHexString(keyString), 16));
    }

    private static byte[] getBytesFromHexString(String key) {
        byte[] keybytes = new byte[key.length() / 2];
        for (int index = 0; index < key.length(); index += 2) {
            keybytes[index / 2] = (byte)((Character.digit(key.charAt(index), 16) << 4) + Character.digit(key.charAt(index + 1), 16));
        }
        return keybytes;
    }

    private Key(byte[] bytes) {
        this.bytes = bytes;
    }

    public String toBase64() {
        return new Base64(0).encodeToString(this.bytes);
    }

    public String toHex() {
        return Hex.encodeHexString((byte[])this.toBytes());
    }

    public byte[] toBytes() {
        return this.bytes;
    }

    public boolean isEmptyKey() {
        return Arrays.equals(this.bytes, Key.EMPTY_KEY.bytes);
    }

    public String toString() {
        return this.toBase64();
    }
}

