/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.problem;

import at.mrdevelopment.esl.core.problem.ProblemIdentifier;
import at.mrdevelopment.esl.core.problem.ProblemStatus;
import at.mrdevelopment.esl.core.problem.QueryProblem;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.toolkit.problem.MessageProblem;
import at.mrdevelopment.toolkit.problem.Problem;
import at.mrdevelopment.toolkit.problem.ProblemSeverity;

public abstract class QueryProblemStatus<T extends Commitable>
implements ProblemStatus {
    private final QueryProblem problem;
    private final DatasetQuery<T, Void> query;
    private final String messageTemplate;
    private final String propertyKey;
    private int count;

    public QueryProblemStatus(DatasetQuery<T, Void> query, ProblemSeverity severity, ProblemIdentifier identifier, String messageTemplate, String propertyKey) {
        this.problem = new QueryProblem(severity, identifier.toString(), null, query.getUrl(), query.getRecordClass());
        this.query = query;
        this.propertyKey = propertyKey;
        this.messageTemplate = messageTemplate;
    }

    @Override
    public Problem getProblem() {
        if (this.count == 0) {
            return new MessageProblem(this.problem.getSeverity(), this.problem.getIdentifier(), this.problem.getMessage());
        }
        return this.problem;
    }

    @Override
    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Override
    public String getValue() {
        return Integer.toString(this.count);
    }

    @Override
    public void update(Transaction<?> transaction) throws DatasetException {
        this.count = this.query.getCount(QueryRestriction.newUnpagedQuery(), transaction);
        this.problem.updateMessage(String.format(this.messageTemplate, this.count));
    }

    @Override
    public boolean isEnabled() {
        return this.count > 0;
    }

    public DatasetQuery<T, Void> getQuery() {
        return this.query;
    }

    public int getCount() {
        return this.count;
    }
}

