/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.problem;

public enum ProblemIdentifier {
    OFFLINE_LABELS("offline-labels", "Labels are offline"),
    UNKNOWN_LABELS("unknown-labels", "Connection status for labels is unknown"),
    ERROR_LABELS("error-labels", "Labels with hardware error"),
    POWER_LOW_LABELS("power-low-labels", "Labels with low battery status (replacement battery should be ordered soon)"),
    POWER_BAD_LABELS("power-bad-labels", "Labels with bad battery status (battery should be replaced immediately)"),
    UNSUCCESSFUL_LABELS("unsuccessful-labels", "Labels with unsuccessful last update"),
    TEMPLATE_INVALID("template-invalid", "Malformed templates (invalid XML)"),
    ACCESS_POINT_OFFLINE("access-point-offline", "Offline access points"),
    ACCESS_POINT_NO_CHANNEL("access-point-no-channel", "Access points without channel set"),
    ACCESS_POINT_CHANNEL_CONFLICT("access-point-channel-conflict", "Conflicting channel configuration on access points"),
    ACCESS_POINT_NO_SECURITY("access-point-no-security", "Security not supported on some access points (software update is required)"),
    ACCESS_POINT_ADVANCED_PROTOCOL("access-point-advanced-protocol", "Advanced access point communication protocol (Thin AP 2.0) supported by all registered access points but disabled in configuration"),
    WAITING_TASKS("waiting-tasks", "Tasks are currently processed"),
    NO_REGISTERED_LABELS("no-registered-labels", "No labels are registered on the system"),
    NO_ACCESS_POINTS("no-access-points", "No access points are registered on the system"),
    LICENSED_ACCESS_POINTS_EXCEEDED("licensed-access-points-exceeded", "Number of licensed access points exceeded"),
    NO_LICENSES("no-licences", "No licenses are installed"),
    NO_PROBLEM("no-problem", "Used for internal logic only"),
    MANUAL_ID_ONLY("manual-id-only", "Access point(s) could not come online, see log for troubleshooting"),
    MANUAL_NOT_DISCOVERED("manual-not-discovered", "Access point(s) could not come online because they were not discovered"),
    MANUAL_NOT_VALID("manual-not-valid", "Access point(s) configuration is not valid"),
    CENTRALIZED_UPDATE_OK("centralized-update-ok", "Configuration update finished successfully"),
    CENTRALIZED_DISABLED("centralized-disabled", "Centralized mode on access point is not enabled"),
    CENTRALIZED_NOT_VALID("centralized-not-valid", "Access point configuration is not valid"),
    CENTRALIZED_UPDATE_NOT_NEEDED("centralized-update-not-needed", "Configuration update was not needed, yet access point could not come online regardless"),
    CENTRALIZED_UPDATE_FAILED("centralized-update-failed", "Access point configuration update failed"),
    CENTRALIZED_NOT_DISCOVERED("centralized-not-discovered", "Access point could not come online because it was not discovered"),
    UNRESOLVABLE("unresolvable", "Access point situation could not be resolved, see log for troubleshooting"),
    DISCOVERY_INCOMPLETE("discovery-incomplete", "Access point discovery incomplete"),
    INIT_FAILED("ap-init-failed", "Access point initialization failed"),
    ACCESS_POINTS_REQUIRE_REINIT("ap-reinit-failed", "Required access point reinit failed"),
    AP_NOT_AVAILABLE("ap-not-available", "Access point not available for SSH connection"),
    AUTHENTICATION_FAILED("ap-cant-authenticate", "Could not authenticate with ap"),
    MATCHING_MISSING("matching-missing", "Labels without matching (level 2 only)"),
    MATCHING_UNREGISTERED("matching-unregistered", "Matchings to unregistered labels (level 2 only)"),
    MATCHING_UNLICENSED("matching-unlicenced", "Matchings to unlicensed labels (level 2 only)"),
    TEMPLATE_MISSING("template-missing", "Matchings to missing template (level 2 only)");

    private final String identifier;
    private final String description;

    private ProblemIdentifier(String identifier, String description) {
        this.identifier = identifier;
        this.description = description;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDescription() {
        return this.description;
    }
}

