/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.labeltype;

import at.mrdevelopment.esl.core.labeltype.DisplayColors;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.toolkit.image.RawImage;
import at.mrdevelopment.toolkit.image.RawImageType;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class LabelTypeConversionTest {
    @Test
    public void testLabelTypeConversions() {
        boolean allLabelsCanBeConverted = true;
        for (LabelType type : LabelType.values()) {
            if (type == LabelType.UNKNOWN || this.canConvertLabelType(type)) continue;
            System.out.println((Object)((Object)type) + " has errors with RawImageType conversion from/to BufferedImage");
            allLabelsCanBeConverted = false;
        }
        Assert.assertTrue((boolean)allLabelsCanBeConverted);
    }

    public boolean canConvertLabelType(LabelType labelType) {
        int bytes = labelType.getDisplayWidth() * labelType.getDisplayHeight();
        if (bytes % 8 != 0) {
            return false;
        }
        DisplayColors displayColors = labelType.getDisplayColors();
        Color[] imageColors = this.initImageColors(displayColors);
        BufferedImage bitCheckeredImage = labelType.getImageRotation() == 90 || labelType.getImageRotation() == 270 ? this.createBitCheckeredImage(imageColors, labelType.getDisplayHeight(), labelType.getDisplayWidth()) : this.createBitCheckeredImage(imageColors, labelType.getDisplayWidth(), labelType.getDisplayHeight());
        RawImage rawImage = displayColors.getRawImageType().fromBufferedImage(bitCheckeredImage, displayColors.getColorMappings());
        if (!this.verifyBytes(rawImage)) {
            return false;
        }
        BufferedImage result = displayColors.getRawImageType().toBufferedImage(rawImage, displayColors.getColorMappings());
        return this.areBufferedImagesEqualPixelByPixel(bitCheckeredImage, result);
    }

    private boolean verifyBytes(RawImage src) {
        byte[] expectedResult = this.createByteArray(src.getType(), src.getWidth(), src.getHeight());
        return Arrays.equals(src.getBytes(), expectedResult);
    }

    private boolean areBufferedImagesEqualPixelByPixel(BufferedImage source, BufferedImage target) {
        if (source.getWidth() != target.getWidth() || source.getHeight() != target.getHeight()) {
            return false;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        WritableRaster srcRaster = source.getRaster();
        WritableRaster resultRaster = target.getRaster();
        int[] srcColor = new int[4];
        int[] resultColor = new int[4];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                srcRaster.getPixel(x, y, srcColor);
                resultRaster.getPixel(x, y, resultColor);
                if (srcColor[0] == resultColor[0] && srcColor[1] == resultColor[1] && srcColor[2] == resultColor[2]) continue;
                return false;
            }
        }
        return true;
    }

    private byte[] createByteArray(RawImageType type, int width, int height) {
        if (type == RawImageType.TYPE_BINARY) {
            return this.createBinaryCheckeredImageByteArray(width, height);
        }
        if (type == RawImageType.TYPE_2BIT) {
            return this.create2BitCheckeredImageByteArray(width, height);
        }
        if (type == RawImageType.LINED_UP_IMAGES) {
            return this.createLinedUpCheckeredImageByteArray(width, height);
        }
        return new byte[0];
    }

    private byte[] createBinaryCheckeredImageByteArray(int width, int height) {
        byte[] result = new byte[width * height / 8];
        String binaryString = this.createBinaryCheckeredString(width, height, false);
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)Integer.parseInt(binaryString.substring(i * 8, (i + 1) * 8), 2);
        }
        return result;
    }

    private byte[] createLinedUpCheckeredImageByteArray(int width, int height) {
        int i;
        byte[] result = new byte[width * height / 4];
        String binaryString = this.createBinaryCheckeredString(width, height, false);
        String binaryStringInverse = this.createBinaryCheckeredString(width, height, true);
        for (i = 0; i < result.length / 2; ++i) {
            result[i] = (byte)Integer.parseInt(binaryString.substring(i * 8, (i + 1) * 8), 2);
        }
        for (i = 0; i < result.length / 2; ++i) {
            int index = i + result.length / 2;
            result[index] = (byte)Integer.parseInt(binaryStringInverse.substring(i * 8, (i + 1) * 8), 2);
        }
        return result;
    }

    private byte[] create2BitCheckeredImageByteArray(int width, int height) {
        byte[] result = new byte[width * height / 4];
        String binaryString = this.create2BitCheckeredString(width, height);
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)Integer.parseInt(binaryString.substring(i * 8, (i + 1) * 8), 2);
        }
        return result;
    }

    private String createBinaryCheckeredString(int width, int height, boolean inverse) {
        StringBuilder sb = new StringBuilder();
        char color = inverse ? (char)'0' : '1';
        char nocolor = inverse ? (char)'1' : '0';
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (y % 2 == 0) {
                    if (x % 2 == 0) {
                        sb.append(color);
                        continue;
                    }
                    sb.append(nocolor);
                    continue;
                }
                if (x % 2 == 0) {
                    sb.append(nocolor);
                    continue;
                }
                sb.append(color);
            }
        }
        return sb.toString();
    }

    private String create2BitCheckeredString(int width, int height) {
        StringBuilder sb = new StringBuilder();
        width *= 2;
        height *= 2;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; x += 2) {
                if (y % 2 == 0) {
                    if (x % 4 == 0) {
                        sb.append('0');
                        sb.append('1');
                        continue;
                    }
                    sb.append('0');
                    sb.append('0');
                    continue;
                }
                if (x % 4 == 0) {
                    sb.append('0');
                    sb.append('0');
                    continue;
                }
                sb.append('0');
                sb.append('1');
            }
        }
        return sb.toString();
    }

    private Color[] initImageColors(DisplayColors displayColors) {
        Color[] result = new Color[]{Color.BLACK, Color.WHITE};
        if (displayColors == DisplayColors.BLACK_WHITE_RED) {
            result[1] = Color.RED;
        } else if (displayColors == DisplayColors.BLACK_WHITE_YELLOW) {
            result[1] = Color.YELLOW;
        }
        return result;
    }

    private BufferedImage createBitCheckeredImage(Color[] imageColors, int width, int height) {
        BufferedImage bi = new BufferedImage(width, height, 1);
        WritableRaster biRaster = bi.getRaster();
        int[] color1components = new int[]{imageColors[0].getRed(), imageColors[0].getGreen(), imageColors[0].getBlue(), imageColors[0].getAlpha()};
        int[] color2components = new int[]{imageColors[1].getRed(), imageColors[1].getGreen(), imageColors[1].getBlue(), imageColors[1].getAlpha()};
        for (int i = 0; i < bi.getHeight(); ++i) {
            for (int j = 0; j < bi.getWidth(); ++j) {
                int[] component;
                if (i % 2 == 0) {
                    component = j % 2 == 0 ? color1components : color2components;
                    biRaster.setPixel(j, i, component);
                    continue;
                }
                component = j % 2 == 0 ? color2components : color1components;
                biRaster.setPixel(j, i, component);
            }
        }
        return bi;
    }
}

