/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.labeltype;

import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.labeltype.Display;
import at.mrdevelopment.esl.core.labeltype.DisplayColors;
import at.mrdevelopment.esl.core.labeltype.DisplayDriving;
import at.mrdevelopment.esl.core.labeltype.LabelGeneration;
import at.mrdevelopment.toolkit.image.ColorMapping;
import at.mrdevelopment.toolkit.image.RawImageType;
import java.util.Set;

public enum LabelType {
    G1_0160_BW_000("1.6 BW", Display.BW_160, 0),
    G1_0160_BW_090("1.6 BW", Display.BW_160, 90),
    G1_0160_BW_180("1.6 BW", Display.BW_160, 180),
    G1_0160_BW_270("1.6 BW", Display.BW_160, 270),
    G1_0220_BW_000("2.2 BW", Display.BW_220, 0),
    G1_0220_BW_090("2.2 BW", Display.BW_220, 90),
    G1_0220_BW_180("2.2 BW", Display.BW_220, 180),
    G1_0220_BW_270("2.2 BW", Display.BW_220, 270),
    G1_0260_BW_000("2.6 BW", Display.BW_260, 0),
    G1_0260_BW_090("2.6 BW", Display.BW_260, 90),
    G1_0260_BW_180("2.6 BW", Display.BW_260, 180),
    G1_0260_BW_270("2.6 BW", Display.BW_260, 270),
    G1_0270_BW_000("2.7 BW", Display.BW_270, 0),
    G1_0270_BW_090("2.7 BW", Display.BW_270, 90),
    G1_0270_BW_180("2.7 BW", Display.BW_270, 180),
    G1_0270_BW_270("2.7 BW", Display.BW_270, 270),
    G1_0420_BW_000("4.2 BW", Display.BW_420, 0),
    G1_0420_BW_090("4.2 BW", Display.BW_420, 90),
    G1_0420_BW_180("4.2 BW", Display.BW_420, 180),
    G1_0420_BW_270("4.2 BW", Display.BW_420, 270),
    G1_0450_BW_000("4.5 BW", Display.BW_450, 0),
    G1_0450_BW_090("4.5 BW", Display.BW_450, 90),
    G1_0450_BW_180("4.5 BW", Display.BW_450, 180),
    G1_0450_BW_270("4.5 BW", Display.BW_450, 270),
    G1_0600_BW_000("6.0 BW", Display.BW_600, 0),
    G1_0600_BW_090("6.0 BW", Display.BW_600, 90),
    G1_0600_BW_180("6.0 BW", Display.BW_600, 180),
    G1_0600_BW_270("6.0 BW", Display.BW_600, 270),
    G1_0740_BW_000("7.4 BW", Display.BW_740, 0),
    G1_0740_BW_090("7.4 BW", Display.BW_740, 90),
    G1_0740_BW_180("7.4 BW", Display.BW_740, 180),
    G1_0740_BW_270("7.4 BW", Display.BW_740, 270),
    G1_1220_BW_000("12.2 BW", Display.BW_1220, 0),
    G1_1220_BW_090("12.2 BW", Display.BW_1220, 90),
    G1_1220_BW_180("12.2 BW", Display.BW_1220, 180),
    G1_1220_BW_270("12.2 BW", Display.BW_1220, 270),
    G1_0160_BWR_000("1.6 BWR", Display.BWR_160, 0),
    G1_0160_BWR_090("1.6 BWR", Display.BWR_160, 90),
    G1_0160_BWR_180("1.6 BWR", Display.BWR_160, 180),
    G1_0160_BWR_270("1.6 BWR", Display.BWR_160, 270),
    G1_0220_BWR_000("2.2 BWR", Display.BWR_220, 0),
    G1_0220_BWR_090("2.2 BWR", Display.BWR_220, 90),
    G1_0220_BWR_180("2.2 BWR", Display.BWR_220, 180),
    G1_0220_BWR_270("2.2 BWR", Display.BWR_220, 270),
    G1_0260_BWR_000("2.6 BWR", Display.BWR_260, 0),
    G1_0260_BWR_090("2.6 BWR", Display.BWR_260, 90),
    G1_0260_BWR_180("2.6 BWR", Display.BWR_260, 180),
    G1_0260_BWR_270("2.6 BWR", Display.BWR_260, 270),
    G1_0270_BWR_000("2.7 BWR", Display.BWR_270, 0),
    G1_0270_BWR_090("2.7 BWR", Display.BWR_270, 90),
    G1_0270_BWR_180("2.7 BWR", Display.BWR_270, 180),
    G1_0270_BWR_270("2.7 BWR", Display.BWR_270, 270),
    G1_0370_BWR_000("3.7 BWR", Display.BWR_370, 0),
    G1_0370_BWR_090("3.7 BWR", Display.BWR_370, 90),
    G1_0370_BWR_180("3.7 BWR", Display.BWR_370, 180),
    G1_0370_BWR_270("3.7 BWR", Display.BWR_370, 270),
    G1_0420_BWR_000("4.2 BWR", Display.BWR_420, 0),
    G1_0420_BWR_090("4.2 BWR", Display.BWR_420, 90),
    G1_0420_BWR_180("4.2 BWR", Display.BWR_420, 180),
    G1_0420_BWR_270("4.2 BWR", Display.BWR_420, 270),
    G1_0450_BWR_000("4.5 BWR", Display.BWR_450, 0),
    G1_0450_BWR_090("4.5 BWR", Display.BWR_450, 90),
    G1_0450_BWR_180("4.5 BWR", Display.BWR_450, 180),
    G1_0450_BWR_270("4.5 BWR", Display.BWR_450, 270),
    G1_0590_BWR_000("5.9 BWR", Display.BWR_590, 0),
    G1_0590_BWR_090("5.9 BWR", Display.BWR_590, 90),
    G1_0590_BWR_180("5.9 BWR", Display.BWR_590, 180),
    G1_0590_BWR_270("5.9 BWR", Display.BWR_590, 270),
    G1_0600_BWR_000("6.0 BWR", Display.BWR_600, 0),
    G1_0600_BWR_090("6.0 BWR", Display.BWR_600, 90),
    G1_0600_BWR_180("6.0 BWR", Display.BWR_600, 180),
    G1_0600_BWR_270("6.0 BWR", Display.BWR_600, 270),
    G1_0740_BWR_000("7.4 BWR", Display.BWR_740, 0),
    G1_0740_BWR_090("7.4 BWR", Display.BWR_740, 90),
    G1_0740_BWR_180("7.4 BWR", Display.BWR_740, 180),
    G1_0740_BWR_270("7.4 BWR", Display.BWR_740, 270),
    G1_0970_BWR_000("9.7 BWR", Display.BWR_970, 0),
    G1_0970_BWR_090("9.7 BWR", Display.BWR_970, 90),
    G1_0970_BWR_180("9.7 BWR", Display.BWR_970, 180),
    G1_0970_BWR_270("9.7 BWR", Display.BWR_970, 270),
    G1_1220_BWR_000("12.2 BWR", Display.BWR_1220, 0),
    G1_1220_BWR_090("12.2 BWR", Display.BWR_1220, 90),
    G1_1220_BWR_180("12.2 BWR", Display.BWR_1220, 180),
    G1_1220_BWR_270("12.2 BWR", Display.BWR_1220, 270),
    G1_0160_BWY_000("1.6 BWY", Display.BWY_160, 0),
    G1_0160_BWY_090("1.6 BWY", Display.BWY_160, 90),
    G1_0160_BWY_180("1.6 BWY", Display.BWY_160, 180),
    G1_0160_BWY_270("1.6 BWY", Display.BWY_160, 270),
    G1_0220_BWY_000("2.2 BWY", Display.BWY_220, 0),
    G1_0220_BWY_090("2.2 BWY", Display.BWY_220, 90),
    G1_0220_BWY_180("2.2 BWY", Display.BWY_220, 180),
    G1_0220_BWY_270("2.2 BWY", Display.BWY_220, 270),
    G1_0260_BWY_000("2.6 BWY", Display.BWY_260, 0),
    G1_0260_BWY_090("2.6 BWY", Display.BWY_260, 90),
    G1_0260_BWY_180("2.6 BWY", Display.BWY_260, 180),
    G1_0260_BWY_270("2.6 BWY", Display.BWY_260, 270),
    G1_0270_BWY_000("2.7 BWY", Display.BWY_270, 0),
    G1_0270_BWY_090("2.7 BWY", Display.BWY_270, 90),
    G1_0270_BWY_180("2.7 BWY", Display.BWY_270, 180),
    G1_0270_BWY_270("2.7 BWY", Display.BWY_270, 270),
    G1_0420_BWY_000("4.2 BWY", Display.BWY_420, 0),
    G1_0420_BWY_090("4.2 BWY", Display.BWY_420, 90),
    G1_0420_BWY_180("4.2 BWY", Display.BWY_420, 180),
    G1_0420_BWY_270("4.2 BWY", Display.BWY_420, 270),
    G1_0450_BWY_000("4.5 BWY", Display.BWY_450, 0),
    G1_0450_BWY_090("4.5 BWY", Display.BWY_450, 90),
    G1_0450_BWY_180("4.5 BWY", Display.BWY_450, 180),
    G1_0450_BWY_270("4.5 BWY", Display.BWY_450, 270),
    G1_0600_BWY_000("6.0 BWY", Display.BWY_600, 0),
    G1_0600_BWY_090("6.0 BWY", Display.BWY_600, 90),
    G1_0600_BWY_180("6.0 BWY", Display.BWY_600, 180),
    G1_0600_BWY_270("6.0 BWY", Display.BWY_600, 270),
    G1_0740_BWY_000("7.4 BWY", Display.BWY_740, 0),
    G1_0740_BWY_090("7.4 BWY", Display.BWY_740, 90),
    G1_0740_BWY_180("7.4 BWY", Display.BWY_740, 180),
    G1_0740_BWY_270("7.4 BWY", Display.BWY_740, 270),
    G1_1220_BWY_000("12.2 BWY", Display.BWY_1220, 0),
    G1_1220_BWY_090("12.2 BWY", Display.BWY_1220, 90),
    G1_1220_BWY_180("12.2 BWY", Display.BWY_1220, 180),
    G1_1220_BWY_270("12.2 BWY", Display.BWY_1220, 270),
    BATTERY_160(G1_0160_BW_270),
    BATTERY_220(G1_0220_BW_090),
    BATTERY_260(G1_0260_BW_270),
    BATTERY_270_TCON(G1_0270_BW_270),
    BATTERY_420(G1_0420_BW_000),
    BATTERY_450(G1_0450_BW_270),
    BATTERY_600(G1_0600_BW_000),
    BATTERY_1200(G1_1220_BW_270),
    BATTERY_160_RED(G1_0160_BWR_270),
    BATTERY_220_RED(G1_0220_BWR_090),
    BATTERY_260_RED(G1_0260_BWR_270),
    BATTERY_270_RED(G1_0270_BWR_270),
    BATTERY_420_RED(G1_0420_BWR_000),
    BATTERY_450_RED(G1_0450_BWR_270),
    BATTERY_600_RED(G1_0600_BWR_000),
    BATTERY_740_RED(G1_0740_BWR_180),
    BATTERY_1200_RED(G1_1220_BWR_270),
    BATTERY_160_BWY(G1_0160_BWY_270),
    BATTERY_220_BWY(G1_0220_BWY_090),
    BATTERY_260_BWY(G1_0260_BWY_270),
    BATTERY_270_BWY(G1_0270_BWY_270),
    BATTERY_420_BWY(G1_0420_BWY_000),
    BATTERY_450_BWY(G1_0450_BWY_270),
    BATTERY_600_BWY(G1_0600_BWY_000),
    BATTERY_740_BWY(G1_0740_BWY_180),
    BATTERY_1200_BWY(G1_1220_BWY_270),
    TESTBOX_270(true, "Testbox", LabelGeneration.G1, Display.BW_270_COG, 0),
    DISPLAY_RAIL_DEMO_132_SMALL(true, "Display Rail Demo 132 Small", LabelGeneration.G1, Display.DISPLAY_RAIL_DEMO_132_SMALL, 0),
    DISPLAY_RAIL_DEMO_132_MEDIUM(true, "Display Rail Demo 132 Medium", LabelGeneration.G1, Display.DISPLAY_RAIL_DEMO_132_MEDIUM, 0),
    DISPLAY_RAIL_DEMO_132_LARGE(true, "Display Rail Demo 132 Large", LabelGeneration.G1, Display.DISPLAY_RAIL_DEMO_132_LARGE, 0),
    BATTERY_200(true, "2.0 BW", LabelGeneration.G1, Display.BW_200_COG, 0, Page.PAGE_8, Page.PAGE_9),
    BATTERY_270_FLIPPED(true, "2.7 BW", LabelGeneration.G1, Display.BW_270_COG, 180, Page.PAGE_8, Page.PAGE_9),
    BATTERY_441_FLIPPED(true, "4.4 BW", LabelGeneration.G1, Display.BW_441, 180, Page.PAGE_12, Page.PAGE_13),
    BATTERY_740_FLIPPED(true, "7.4 BW", LabelGeneration.G1, Display.BW_740, 180, Page.PAGE_12, Page.PAGE_13),
    BATTERY_1020(true, "10.2 BW", LabelGeneration.G1, Display.BW_1020_TCON, 0),
    BATTERY_1020_FLIPPED(true, "10.2 BW", LabelGeneration.G1, Display.BW_1020_TCON, 180),
    BATTERY_290_RED(true, "2.9 BWR", LabelGeneration.G1, Display.BWR_290, 270),
    BATTERY_441_SPECTRA(true, "4.4 BWR", LabelGeneration.G1, Display.BWR_441, 0, Page.PAGE_12, Page.PAGE_13),
    BATTERY_SEGMENTED(true, "S-Tag HF", LabelGeneration.G1, Display.BW_E_INK_SEGMENTED_128, 0, Page.PAGE_8, Page.PAGE_9),
    SES_GTAG_6(true, "G-Tag 6 HF", LabelGeneration.G1, Display.BW_LCD_600, 0),
    BATTERY_200_FLIPPED(false, "2.0 BW", LabelGeneration.G1, Display.BW_200_COG, 180, Page.PAGE_8, Page.PAGE_9),
    BATTERY_270(false, "2.7 BW", LabelGeneration.G1, Display.BW_270_COG, 0, Page.PAGE_8, Page.PAGE_9),
    BATTERY_441(false, "4.4 BW", LabelGeneration.G1, Display.BW_441, 0, Page.PAGE_12, Page.PAGE_13),
    BATTERY_740(false, "7.4 BW", LabelGeneration.G1, Display.BW_740, 0, Page.PAGE_12, Page.PAGE_13),
    BATTERY_441_RED(false, "4.4 BWR", LabelGeneration.G1, Display.BWR_441, 0),
    STAG_256(false, "S-Tag HF", LabelGeneration.G1, Display.BW_LCD_SEGMENTED_256, 0),
    BATTERY_270_BILLA(true, "Billa Bestpreis 2.7", LabelGeneration.G1, Display.BW_270_COG, 0, Page.PAGE_8, Page.PAGE_9),
    BOSSARD(G1_0220_BWR_270),
    UNKNOWN(true, "Unknown label type", LabelGeneration.UNKNOWN, Display.UNKNOWN, 0);

    private final boolean hidden;
    private final String name;
    private final Display display;
    private final LabelGeneration labelGeneration;
    private final Page registrationPage;
    private final Page resetPage;
    private final int imageRotation;

    public static void main(String[] args) {
        System.out.format("  %-22s %-26s %-10s %-3s %-8s %-15s %-15s %-18s %-7s %-7s %-8s %-8s %-8s%n", "Enum", "Name", "Resolution", "DPI", "Rotation", "Display", "Driving", "Colors", "RF", "Power", "Register", "Reset", "Compress");
        for (LabelType labelType : LabelType.values()) {
            System.out.format("%s %-22s %-26s  %4d %4d %8d %3d %-15s %-15s %-18s %-7s %-7s %-8s %-8s %b%n", new Object[]{labelType.isNonStandardDefinition() ? "!" : " ", labelType.toString(), labelType.name, labelType.display.getDisplaySize().getDisplayWidth(), labelType.display.getDisplaySize().getDisplayHeight(), labelType.display.getDisplaySize().getDisplayDpi(), labelType.imageRotation, labelType.display.getDisplayTechnology(), labelType.display.getDisplayDriving(), labelType.display.getDisplayColors(), labelType.labelGeneration.getRfTechnology(), labelType.labelGeneration.getPowerSource(), labelType.registrationPage, labelType.resetPage, labelType.display.isCompressionAllowed()});
        }
    }

    private LabelType(boolean hidden, String name, LabelGeneration labelGeneration, Display display, int imageRotation, Page registrationPage, Page resetPage) {
        if (imageRotation != 0 && imageRotation != 90 && imageRotation != 180 && imageRotation != 270) {
            throw new IllegalArgumentException("Invalid rotation");
        }
        this.hidden = hidden;
        this.name = name;
        this.labelGeneration = labelGeneration;
        this.display = display;
        this.registrationPage = registrationPage;
        this.resetPage = resetPage;
        this.imageRotation = imageRotation;
    }

    private LabelType(boolean hidden, String name, LabelGeneration labelGeneration, Display display, int imageRotation) {
        this(hidden, name, labelGeneration, display, imageRotation, Page.REGISTRATION, Page.RESET);
    }

    private LabelType(String name, Display display, int imageRotation) {
        this(false, name, LabelGeneration.G1, display, imageRotation);
    }

    private LabelType(LabelType o) {
        this(false, o.name, o.labelGeneration, o.display, o.imageRotation, o.registrationPage, o.resetPage);
    }

    public boolean isNonStandardDefinition() {
        return this.getDisplayDriving() != DisplayDriving.TCON || this.labelGeneration != LabelGeneration.G1 || this.registrationPage != Page.REGISTRATION || this.resetPage != Page.RESET || !this.display.isCompressionAllowed();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getName() {
        return this.name;
    }

    public int getDisplayWidth() {
        return this.display.getDisplaySize().getDisplayWidth();
    }

    public int getDisplayHeight() {
        return this.display.getDisplaySize().getDisplayHeight();
    }

    public int getDisplayDpi() {
        return this.display.getDisplaySize().getDisplayDpi();
    }

    public DisplayTechnology getDisplayTechnology() {
        return this.display.getDisplayTechnology();
    }

    public DisplayDriving getDisplayDriving() {
        return this.display.getDisplayDriving();
    }

    public DisplayColors getDisplayColors() {
        return this.display.getDisplayColors();
    }

    public RawImageType getRawImageType() {
        return this.display.getDisplayColors().getRawImageType();
    }

    public ColorMapping[] getColorMappings() {
        return this.display.getDisplayColors().getColorMappings();
    }

    public RFTechnology getRfTechnology() {
        return this.labelGeneration.getRfTechnology();
    }

    public PowerSource getPowerSource() {
        return this.labelGeneration.getPowerSource();
    }

    public int getAvailablePageCount() {
        return this.getPageCount() - 2;
    }

    public int getPageCount() {
        return 15;
    }

    public Page getRegistrationPage() {
        return this.registrationPage;
    }

    public Page getResetPage() {
        return this.resetPage;
    }

    public int getImageRotation() {
        return this.imageRotation;
    }

    public int getRestoreImageRotation() {
        return 360 - this.imageRotation;
    }

    public boolean isFlipImage() {
        return this.imageRotation == 180;
    }

    public boolean isTwistedImage() {
        return this.imageRotation == 90 || this.imageRotation == 270;
    }

    public boolean isSegmented() {
        return this.getDisplayTechnology() == DisplayTechnology.E_INK_SEGMENTED || this.getDisplayTechnology() == DisplayTechnology.LCD_SEGMENTED;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public boolean isValidForSendingImages() {
        return !this.isUnknown() && this.getDisplayHeight() > 0 && this.getDisplayWidth() > 0;
    }

    public Set<HardwareFeature> getHardwareFeatures() {
        return this.labelGeneration.getHardwareFeatures();
    }

    public boolean hasHardwareFeatures(HardwareFeature hardwareFeature) {
        return this.labelGeneration.hasHardwareFeatures(hardwareFeature);
    }

    public Display getDisplay() {
        return this.display;
    }

    public static LabelType fromString(String name) {
        try {
            return LabelType.valueOf(name);
        }
        catch (Exception exc) {
            return UNKNOWN;
        }
    }

    public boolean isCompressionAllowed() {
        return this.display.isCompressionAllowed();
    }

    public static enum HardwareFeature {
        NFC,
        BUTTONS,
        BASIC_LED;

    }

    public static enum PowerSource {
        UNKNOWN,
        BATTERY,
        PHOTOVOLTAICS;

    }

    public static enum RFTechnology {
        UNKNONW,
        CC251X;

    }

    public static enum DisplayTechnology {
        UNKNOWN,
        E_INK_V110,
        E_INK_SPECTRA,
        DTP_LCD,
        E_INK_SEGMENTED,
        LCD_SEGMENTED;

    }
}

