/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.labeltype;

import at.mrdevelopment.esl.core.labeltype.LabelLookupTableProperties;
import at.mrdevelopment.toolkit.firmware.LabelLookupTable;
import at.mrdevelopment.toolkit.firmware.LookupTableEntry;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public enum LabelLookupTables {
    SWITCH_PAGE_TIMEOUT(new LabelLookupTable(8, LabelLookupTableProperties.DEFAULT_LOOKUP_BASE, LabelLookupTableProperties.DEFAULT_LOOKUP_ADD), TimeUnit.MINUTES),
    BASIC_LED_DURATION(new LabelLookupTable(8, LabelLookupTableProperties.DEFAULT_LOOKUP_BASE, LabelLookupTableProperties.DEFAULT_LOOKUP_ADD), TimeUnit.MINUTES);

    private final LabelLookupTable lookupTable;
    private final TimeUnit timeUnit;

    private LabelLookupTables(LabelLookupTable lookupTable, TimeUnit timeUnit) {
        this.lookupTable = lookupTable;
        this.timeUnit = timeUnit;
    }

    public LabelLookupTable getLookupTable() {
        return this.lookupTable;
    }

    public Collection<LookupTableEntry> getEntries() {
        List indices = this.lookupTable.getIndices();
        return Collections2.transform((Collection)indices, (Function)new Function<LabelLookupTable.LookupTableIndex, LookupTableEntry>(){

            public LookupTableEntry apply(LabelLookupTable.LookupTableIndex index) {
                return new LookupTableEntry(index, LabelLookupTables.this.lookupTable.getValue(index), LabelLookupTables.this.timeUnit);
            }
        });
    }
}

