/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.labeltype;

import at.mrdevelopment.esl.core.labeltype.LabelType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum LabelGeneration {
    G1(LabelType.RFTechnology.CC251X, LabelType.PowerSource.BATTERY, LabelType.HardwareFeature.NFC, LabelType.HardwareFeature.BUTTONS, LabelType.HardwareFeature.BASIC_LED),
    UNKNOWN(LabelType.RFTechnology.UNKNONW, LabelType.PowerSource.UNKNOWN, new LabelType.HardwareFeature[0]);

    private final LabelType.RFTechnology rfTechnology;
    private final LabelType.PowerSource powerSource;
    private final Set<LabelType.HardwareFeature> hardwareFeatures;

    private LabelGeneration(LabelType.RFTechnology rfTechnology, LabelType.PowerSource powerSource, LabelType.HardwareFeature ... hardwareFeatures) {
        this.rfTechnology = rfTechnology;
        this.powerSource = powerSource;
        this.hardwareFeatures = new HashSet<LabelType.HardwareFeature>(Arrays.asList(hardwareFeatures));
    }

    public LabelType.RFTechnology getRfTechnology() {
        return this.rfTechnology;
    }

    public LabelType.PowerSource getPowerSource() {
        return this.powerSource;
    }

    public Set<LabelType.HardwareFeature> getHardwareFeatures() {
        return Collections.unmodifiableSet(this.hardwareFeatures);
    }

    public boolean hasHardwareFeatures(LabelType.HardwareFeature hardwareFeature) {
        return this.hardwareFeatures.contains((Object)hardwareFeature);
    }
}

