/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.accesspoint;

import java.util.LinkedList;

public enum ConnectionMode {
    INBOUND("inbound"),
    OUTBOUND("outbound");

    private final String mode;

    private ConnectionMode(String mode) {
        this.mode = mode;
    }

    public String toString() {
        return this.mode;
    }

    public boolean isOutbound() {
        return this.mode.equals("outbound");
    }

    public static ConnectionMode getFrom(boolean outboundModeEnable) {
        return outboundModeEnable ? OUTBOUND : INBOUND;
    }

    public static ConnectionMode getFrom(String strMode) {
        ConnectionMode mode = null;
        for (ConnectionMode cm : ConnectionMode.values()) {
            if (!cm.mode.equals(strMode)) continue;
            mode = cm;
        }
        return mode;
    }

    public static String listValues() {
        StringBuilder stb = new StringBuilder(32);
        for (ConnectionMode cm : ConnectionMode.values()) {
            if (stb.length() > 0) {
                stb.append(", ").append((Object)cm);
                continue;
            }
            stb.append((Object)cm);
        }
        return stb.toString();
    }

    public static String[] arrayValues() {
        LinkedList<String> values = new LinkedList<String>();
        for (ConnectionMode cm : ConnectionMode.values()) {
            values.add(cm.mode);
        }
        return values.toArray(new String[0]);
    }
}

