/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.accesspoint;

public enum ConfigurationMode {
    MANUAL{

        public String toString() {
            return "Manual configuration";
        }
    }
    ,
    CENTRALIZED_STATIC{

        public String toString() {
            return "Centralized configuration with static IP address";
        }
    }
    ,
    CENTRALIZED_DHCP{

        public String toString() {
            return "Centralized configuration with DHCP";
        }
    };


    public static ConfigurationMode from(String input) {
        ConfigurationMode result = null;
        if (input != null) {
            if (input.equalsIgnoreCase("m") || input.equalsIgnoreCase("manual")) {
                result = MANUAL;
            } else if (input.equalsIgnoreCase("c") || input.equalsIgnoreCase("centralized")) {
                result = CENTRALIZED_DHCP;
            }
        }
        return result;
    }

    public static ConfigurationMode forValue(String value) {
        for (ConfigurationMode mode : ConfigurationMode.values()) {
            if (!value.equalsIgnoreCase(mode.toString())) continue;
            return mode;
        }
        return null;
    }
}

