/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.accesspoint;

public enum AccessPointType {
    SIMULATED("Simulated Access Point", "Simulated AP", 8080),
    IMAGOTAG("SES-imagotag Access Point AP-2010", "AP-2010", 8080),
    SIMULATED_THIN_AP("Simulated Thin Access Point", "Simulated Thin-AP UDP", 7353),
    LANCOM("LANCOM L-151E or L-322E", "MAP-2014", 7353),
    USB_AP("USB Access Point", "USB AP", 8080);

    private final String deviceName;
    private final int defaultPort;
    private final String shortName;

    private AccessPointType(String deviceName, String shortName, int defaultPort) {
        this.deviceName = deviceName;
        this.shortName = shortName;
        this.defaultPort = defaultPort;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public boolean isSimulated() {
        return this == SIMULATED || this == SIMULATED_THIN_AP;
    }

    public boolean supportsThinAp() {
        return this == LANCOM || this == SIMULATED_THIN_AP || this == SIMULATED;
    }

    public boolean useThinApController() {
        return this == LANCOM || this == SIMULATED_THIN_AP;
    }

    public boolean isUdp() {
        return this == LANCOM || this == SIMULATED_THIN_AP;
    }
}

