/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.accesspoint;

import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;

public enum AccessPointModel {
    ACCESSPOINT_2010("accesspoint-2010"),
    ACCESSPOINT_2018("standalone-board"),
    CISCO_ACCESSPOINT_2018("cisco-addon-board");

    private final String model;

    private AccessPointModel(String model) {
        this.model = model;
    }

    public String toString() {
        return this.model;
    }

    public static AccessPointModel getFrom(String strMode) {
        AccessPointModel model = null;
        for (AccessPointModel apm : AccessPointModel.values()) {
            if (!apm.model.equals(strMode)) continue;
            model = apm;
        }
        return model;
    }

    public static String[] arrayValues() {
        LinkedList<String> values = new LinkedList<String>();
        for (AccessPointModel apm : AccessPointModel.values()) {
            values.add(apm.model);
        }
        return values.toArray(new String[0]);
    }

    public static String getUsageString() {
        return StringUtils.join((Object[])AccessPointModel.arrayValues(), (String)"|");
    }
}

