/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.accesspoint;

import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import org.apache.commons.lang.StringUtils;

public class AccessPointHelper {
    public static ParseResult parse(int accessPointId, String address) {
        return AccessPointHelper.parse(accessPointId, address, false);
    }

    public static ParseResult parse(int accessPointId, String address, boolean emptyAddressAllowed) {
        ParseResult result = new ParseResult();
        if (address == null) {
            result.isOk = emptyAddressAllowed;
            result.address = "";
            result.port = -1;
            return result;
        }
        String[] splitted = StringUtils.splitPreserveAllTokens((String)address, (String)":");
        if (splitted.length == 1) {
            if (!splitted[0].isEmpty()) {
                result.address = splitted[0];
                result.port = AccessPointTypeMapping.getType(accessPointId).getDefaultPort();
            } else {
                result.isOk = false;
            }
        } else if (splitted.length == 2) {
            if (!splitted[0].isEmpty()) {
                result.address = splitted[0];
                try {
                    result.port = Integer.valueOf(splitted[1]);
                    if (result.port < 0 || result.port > 65535) {
                        result.isOk = false;
                    }
                }
                catch (NumberFormatException nme) {
                    result.isOk = false;
                }
            } else {
                result.isOk = false;
            }
        } else if (StringUtils.isNotBlank((String)address)) {
            result.isOk = false;
        } else {
            result.address = "";
            result.port = -1;
        }
        return result;
    }

    public static class ParseResult {
        public boolean isOk = true;
        public String address = null;
        public Integer port = -1;
    }
}

