/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum WirelessChannel {
    CHANNEL_0(0, 12, 2404.0, false),
    CHANNEL_1(1, 29, 2410.0, false),
    CHANNEL_2(2, 63, 2422.0, false),
    CHANNEL_3(3, 70, 2425.0, true),
    CHANNEL_4(4, 120, 2442.0, false),
    CHANNEL_5(5, 141, 2450.0, true),
    CHANNEL_6(6, 177, 2462.0, false),
    CHANNEL_7(7, 200, 2470.0, false),
    CHANNEL_8(8, 213, 2474.0, true),
    CHANNEL_9(9, 200, 2477.0, true),
    CHANNEL_10(10, 227, 2480.0, true);

    public static final WirelessChannel FIRST_CHANNEL;
    public static final WirelessChannel LAST_CHANNEL;
    public static final int CHANNEL_COUNT;
    private static final Set<WirelessChannel> CHANNELS_SET;
    private final int logicalChannel;
    private final int physicalChannel;
    private final double peakFrequency;
    private final boolean recommended;

    private WirelessChannel(int logicalBaseChannel, int physicalBaseChannel, double peakFrequency, boolean recommended) {
        this.logicalChannel = logicalBaseChannel;
        this.physicalChannel = physicalBaseChannel;
        this.peakFrequency = peakFrequency;
        this.recommended = recommended;
    }

    public int getLogicalChannel() {
        return this.logicalChannel;
    }

    public int getPhysicalChannel() {
        return this.physicalChannel;
    }

    public double getPeakFrequency() {
        return this.peakFrequency;
    }

    public int getChannelId() {
        return this.logicalChannel;
    }

    public String getChannelName() {
        return String.format("Channel %d", this.logicalChannel);
    }

    public boolean isRecommended() {
        return this.recommended;
    }

    public static WirelessChannel getFromId(int channelId) throws ArrayIndexOutOfBoundsException {
        return WirelessChannel.values()[channelId];
    }

    public static WirelessChannel fromString(String value) throws NumberFormatException, ArrayIndexOutOfBoundsException {
        return WirelessChannel.getFromId(Integer.parseInt(value));
    }

    public static WirelessChannel fromPeakFrequency(String value) {
        StringBuilder stb = new StringBuilder(4);
        for (int idx = 0; idx < value.length() && Character.isDigit(value.charAt(idx)); ++idx) {
            stb.append(value.charAt(idx));
        }
        if (stb.length() == 4) {
            int frequency = Integer.parseInt(stb.toString());
            for (WirelessChannel channel : WirelessChannel.values()) {
                if ((int)Math.round(channel.peakFrequency) != frequency) continue;
                return channel;
            }
            return null;
        }
        return null;
    }

    public static WirelessChannel fromLancomFrequencies(String value) {
        WirelessChannel result = null;
        StringBuilder stb = new StringBuilder(4);
        for (int idx = 0; idx < value.length() && Character.isDigit(value.charAt(idx)); ++idx) {
            stb.append(value.charAt(idx));
        }
        if (stb.length() == 4) {
            int frequency = Integer.parseInt(stb.toString());
            switch (frequency) {
                case 2404: {
                    result = CHANNEL_0;
                    break;
                }
                case 2410: {
                    result = CHANNEL_1;
                    break;
                }
                case 2422: {
                    result = CHANNEL_2;
                    break;
                }
                case 2425: {
                    result = CHANNEL_3;
                    break;
                }
                case 2442: {
                    result = CHANNEL_4;
                    break;
                }
                case 2450: {
                    result = CHANNEL_5;
                    break;
                }
                case 2462: {
                    result = CHANNEL_6;
                    break;
                }
                case 2470: {
                    result = CHANNEL_7;
                    break;
                }
                case 2474: {
                    result = CHANNEL_8;
                    break;
                }
                case 2477: {
                    result = CHANNEL_9;
                    break;
                }
                case 2480: {
                    result = CHANNEL_10;
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    public static Set<WirelessChannel> valueSet() {
        return Collections.unmodifiableSet(CHANNELS_SET);
    }

    public String toString() {
        return Integer.toString(this.getChannelId());
    }

    static {
        FIRST_CHANNEL = CHANNEL_0;
        LAST_CHANNEL = CHANNEL_10;
        CHANNEL_COUNT = WirelessChannel.values().length;
        CHANNELS_SET = new HashSet<WirelessChannel>();
        for (WirelessChannel channel : WirelessChannel.values()) {
            CHANNELS_SET.add(channel);
        }
    }
}

