/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.ESLSystemDefaults;
import at.mrdevelopment.esl.core.FixturesImport;
import at.mrdevelopment.esl.persistence.dataset.NoTransaction;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpServiceClient;
import at.mrdevelopment.toolkit.http.ResponseHandler;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.userinfo.UserInfo;
import java.io.File;
import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;

public class WebserviceFixturesImport
extends FixturesImport {
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final String DEFAULT_PASSWORD = "admin";
    private HttpServiceClient httpClient;

    public static void main(String[] args) {
        try {
            String password;
            ESLSystemDefaults defaults = new ESLSystemDefaults();
            OptionParser parser = new OptionParser();
            ArgumentAcceptingOptionSpec optionFixturesDirectory = parser.accepts("dir", "Fixtures directory").withOptionalArg().ofType(File.class);
            ArgumentAcceptingOptionSpec optionHost = parser.accepts("host", "Host").withOptionalArg().ofType(String.class);
            ArgumentAcceptingOptionSpec optionPort = parser.accepts("port", "Port number").withOptionalArg().ofType(Integer.class);
            ArgumentAcceptingOptionSpec optionSSL = parser.accepts("ssl", "Use SSL").withOptionalArg().ofType(Boolean.class);
            ArgumentAcceptingOptionSpec optionUsername = parser.accepts("user", "Username").withOptionalArg().ofType(String.class);
            ArgumentAcceptingOptionSpec optionPassword = parser.accepts("password", "Password").withOptionalArg().ofType(String.class);
            OptionSpecBuilder optionHelp = parser.accepts("help", "Show this help");
            OptionSet options = parser.parse(args);
            File fixturesDirectory = options.has((OptionSpec)optionFixturesDirectory) ? (File)options.valueOf((OptionSpec)optionFixturesDirectory) : DEFAULT_FIXTURES_DIRECTORY;
            String host = options.has((OptionSpec)optionHost) ? (String)options.valueOf((OptionSpec)optionHost) : DEFAULT_HOSTNAME;
            int port = options.has((OptionSpec)optionPort) ? ((Integer)options.valueOf((OptionSpec)optionPort)).intValue() : defaults.getServicePort();
            boolean ssl = options.has((OptionSpec)optionSSL) ? ((Boolean)options.valueOf((OptionSpec)optionSSL)).booleanValue() : defaults.isUseServerSSL();
            String username = options.has((OptionSpec)optionUsername) ? (String)options.valueOf((OptionSpec)optionUsername) : DEFAULT_PASSWORD;
            String string = password = options.has((OptionSpec)optionPassword) ? (String)options.valueOf((OptionSpec)optionPassword) : DEFAULT_PASSWORD;
            if (options.has((OptionSpec)optionHelp)) {
                parser.printHelpOn((OutputStream)System.out);
            } else {
                WebserviceFixturesImport fixturesImport = new WebserviceFixturesImport(host, port, ssl, username, password);
                fixturesImport.importFixtures(fixturesDirectory, NoTransaction.get());
            }
            System.exit(0);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            System.out.println("Failed to start fixtures import. See log for details.");
            System.exit(1);
        }
    }

    public WebserviceFixturesImport(String host, int port, boolean useSSL, String username, String password) throws InitializationException {
        this.httpClient = new HttpServiceClient(host, port, useSSL);
        this.httpClient.setCredentials(username, password);
    }

    public WebserviceFixturesImport(HttpServiceClient httpClient, UserInfo userInfo) {
        super(userInfo);
        this.httpClient = httpClient;
    }

    @Override
    protected void importFixture(File fixtureFile, Transaction<?> transaction) throws Exception {
        this.executeRequest(fixtureFile);
    }

    private void executeRequest(File fixtureFile) throws Exception {
        final String entityName = this.parseEntityName(fixtureFile);
        HttpPost request = new HttpPost(String.format("/service/%s/store.xml", entityName));
        request.setEntity((HttpEntity)new FileEntity(fixtureFile, ContentType.TEXT_XML));
        this.httpClient.executeRequest((HttpRequestBase)request, (ResponseHandler)new ResponseHandler<Void>(){

            public Void handleResponse(HttpResponse response) throws Exception {
                FixturesImport.logger.info("Importing %s fixture returned status code %d", new Object[]{entityName, response.getStatusLine().getStatusCode()});
                WebserviceFixturesImport.this.getUserInfo().addInfo("Imported fixture for entity '%s'", new Object[]{entityName});
                return null;
            }
        });
    }

    static {
        ESLLogger.initLogger((boolean)false);
    }
}

