/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.TransmissionInfo;

public class TransmissionStatistic {
    private final Integer rssi;
    private final Integer lqi;
    private final Integer transmissionTime;
    public static TransmissionStatistic NO_STATISTIC = new TransmissionStatistic(null, null, null);

    public static TransmissionStatistic timeOnly(int transmissionTime) {
        return new TransmissionStatistic(null, null, transmissionTime);
    }

    public static TransmissionStatistic full(int rssi, int lqi, int transmissionTime) {
        return new TransmissionStatistic(rssi, lqi, transmissionTime);
    }

    public static TransmissionStatistic fromTransmissionInfo(TransmissionInfo dataStatistic, int transmissionTime) {
        if (dataStatistic.hasSignalStatistics()) {
            return TransmissionStatistic.full(dataStatistic.getTransmitterRxMetrics().getRssi(), dataStatistic.getTransmitterRxMetrics().getLqi(), transmissionTime);
        }
        return TransmissionStatistic.timeOnly(transmissionTime);
    }

    private TransmissionStatistic(Integer rssi, Integer lqi, Integer transmissionTime) {
        this.rssi = rssi;
        this.lqi = lqi;
        this.transmissionTime = transmissionTime;
    }

    public Integer getRssi() {
        return this.rssi;
    }

    public Integer getLqi() {
        return this.lqi;
    }

    public Integer getTransmissionTime() {
        return this.transmissionTime;
    }

    public boolean hasTransmissionTime() {
        return this.transmissionTime != null;
    }

    public boolean hasFullStatistic() {
        return this.rssi != null && this.lqi != null && this.transmissionTime != null;
    }
}

