/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.LinkQuality;
import at.mrdevelopment.esl.wireless.WakeupProfile;

public class SyncQuality {
    private static final int SYNC_QUALITY_SYNC_COUNT_MASK = 240;
    private static final int SYNC_QUALITY_RSSI_LEVEL_MASK = 12;
    private static final int SYNC_QUALITY_LQI_LEVEL_MASK = 3;
    private static final int SYNC_QUALITY_SYNC_COUNT_FACTOR = 16;
    private static final int SYNC_QUALITY_SYNC_COUNT_MAX = 15;
    private static final int DEFAULT_SYNC_QUALITY_SYNC_COUNT_MINUTES_PER_COUNT = 4;
    private final int syncQuality;

    public static SyncQuality valueOf(String syncQualityString) {
        return new SyncQuality(Integer.parseInt(syncQualityString));
    }

    public SyncQuality(int syncQuality) {
        if (syncQuality < 0 || syncQuality > 255) {
            throw new IllegalArgumentException("Sync quality is out of valid range");
        }
        this.syncQuality = syncQuality;
    }

    public byte toByte() {
        return (byte)(this.syncQuality & 0xFF);
    }

    public int getSyncQualityValue() {
        return this.syncQuality;
    }

    public int getContinuousSyncCount() {
        return ((this.syncQuality & 0xF0) >> 4) * 16;
    }

    public int getContinuousSyncMinutes(WakeupProfile wakeupProfile) {
        return ((this.syncQuality & 0xF0) >> 4) * this.getSyncCountMinutesPerCount(wakeupProfile);
    }

    public boolean isContinuousSyncCountExceeded() {
        return (this.syncQuality & 0xF0) >> 4 == 15;
    }

    public String getContinuousSyncTimeString(WakeupProfile wakeupProfile) {
        if (this.isContinuousSyncCountExceeded()) {
            return String.format("> %d minutes", this.getContinuousSyncMinutes(wakeupProfile));
        }
        return String.format("%d to %d minutes", this.getContinuousSyncMinutes(wakeupProfile), this.getContinuousSyncMinutes(wakeupProfile) + this.getSyncCountMinutesPerCount(wakeupProfile));
    }

    private int getSyncCountMinutesPerCount(WakeupProfile wakeupProfile) {
        if (wakeupProfile == null) {
            return 4;
        }
        switch (wakeupProfile) {
            case QUARTER: {
                return 1;
            }
            case HALF: {
                return 2;
            }
            case NORMAL: {
                return 4;
            }
            case DOUBLE: {
                return 8;
            }
            case QUAD: {
                return 16;
            }
            case EIGHTH: {
                return 32;
            }
        }
        return 4;
    }

    public LinkQuality getSyncRssiLevel() {
        return LinkQuality.valueOf((this.syncQuality & 0xC) >> 2);
    }

    public LinkQuality getSyncLqiLevel() {
        return LinkQuality.valueOf(this.syncQuality & 3);
    }

    public LinkQuality getSyncQualityLevel() {
        int rssiQuality = this.getSyncRssiLevel().getQualityLevel();
        int lqiQuality = this.getSyncLqiLevel().getQualityLevel();
        return LinkQuality.valueOf(Math.min(rssiQuality, lqiQuality));
    }

    public String toString() {
        return this.getSyncQualityLevel().toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SyncQuality)) {
            return false;
        }
        SyncQuality that = (SyncQuality)other;
        return this.syncQuality == that.syncQuality;
    }
}

