/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.toolkit.sql.SqlUtils;
import com.google.common.collect.Lists;
import java.util.Collection;

public enum Status {
    WAITING(100, "Task is waiting for processing"),
    DELAYED(102, "Task is delayed until other tasks are finished"),
    REPLACE_REQUESTED(103, "Task is marked to be replaced but may already be in transmission (deprecated - status not used anymore)"),
    CANCEL_REQUESTED(104, "Task is marked to be canceled but may already be in transmission (deprecated - status not used anymore)"),
    SUCCESSFUL(200, "Task was executed successfully"),
    REPLACED(300, "Task was replaced by another task"),
    CANCELED(301, "Task was canceled by the user"),
    REMOVED(302, "Task was automatically removed because it will have no effect on the label (deprecated - status not used anymore)"),
    FAILED(400, "Transmission attempt failed"),
    TIMEOUT(401, "Task timed out"),
    ERROR(500, "Task processing failed (for details see error code)");

    public static final Collection<Status> UNFINISHED;
    public static final Collection<Status> FINISHED;
    public static final String UNFINISHED_SQL;
    public static final String FINISHED_SQL;
    public static final String UNSUCCESSFUL_SQL;
    public static final String ABORTED_SQL;
    private final int code;
    private final String description;

    private Status(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isWaiting() {
        return this == WAITING;
    }

    public boolean isDelayed() {
        return this == DELAYED;
    }

    @Deprecated
    public boolean isAbortRequested() {
        return this == REPLACE_REQUESTED || this == CANCEL_REQUESTED;
    }

    public boolean isRemoved() {
        return this == REMOVED;
    }

    public boolean isReplaced() {
        return this == REPLACED;
    }

    public boolean isCanceled() {
        return this == CANCELED;
    }

    public boolean isFailed() {
        return this == FAILED;
    }

    public boolean isSuccessful() {
        return this == SUCCESSFUL;
    }

    public boolean isUnsuccessful() {
        return this == FAILED || this == TIMEOUT || this == ERROR;
    }

    public boolean isAborted() {
        return this == REPLACED || this == CANCELED || this == REMOVED;
    }

    public boolean isFinished() {
        return this.isAborted() || this.isUnsuccessful() || this.isSuccessful();
    }

    public int getCode() {
        return this.code;
    }

    static {
        UNFINISHED = Lists.newArrayList((Object[])new Status[]{WAITING, DELAYED, REPLACE_REQUESTED, CANCEL_REQUESTED});
        FINISHED = Lists.newArrayList((Object[])new Status[]{SUCCESSFUL, REPLACED, CANCELED, REMOVED, FAILED, TIMEOUT, ERROR});
        UNFINISHED_SQL = SqlUtils.getSqlConditionFromCollection(UNFINISHED);
        FINISHED_SQL = SqlUtils.getSqlConditionFromCollection(FINISHED);
        UNSUCCESSFUL_SQL = SqlUtils.getSqlCondition((Object[])new Object[]{FAILED, TIMEOUT, ERROR});
        ABORTED_SQL = SqlUtils.getSqlCondition((Object[])new Object[]{REPLACED, CANCELED, REMOVED});
    }
}

