/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.problem.Problem;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import joptsimple.internal.Strings;
import org.joda.time.DateTime;

public class ServiceStatus
implements Cloneable {
    public static final String KEY_ID = "id";
    public static final String KEY_STORE_ID = "store-id";
    public static final String KEY_STATUS = "status";
    public static final String KEY_SOFTWARE_VERSION = "version";
    public static final String KEY_BUILD = "build";
    public static final String KEY_TIME = "time";
    public static final String KEY_USER_ID = "user-id";
    public static final String KEY_USERNAME = "username";
    public static final String KEY_ROLE = "role";
    public static final String KEY_REGISTERED_RECORDS = "registered-records";
    public static final String KEY_CUSTOM_FIELDS = "custom-fields.";
    public static final String KEY_LICENSED_MODE = "licensed-mode";
    public static final String KEY_LICENSED_ACCESS_POINTS = "licensed-access-points";
    public static final String KEY_LICENSED_LABELS = "licensed-labels";
    public static final String KEY_LICENSED_CUSTOMER = "licensed-customer";
    public static final String KEY_LICENSED_PRODUCTIVE = "licensed-productive";
    public static final String KEY_SYSTEM_SERIAL = "system-serial";
    public static final String KEY_DEVICE_TYPE = "device-type";
    public static final String KEY_DEVICE_MODE = "device-mode";
    public static final String KEY_ACCESS_POINT_MODEL = "device-model";
    public static final String KEY_FIRMWARE_VERSION = "firmware-version";
    public static final String KEY_EXTENDED_VERSION = "extended-version";
    public static final String KEY_HARDWARE_VERSION = "hardware-version";
    public static final String KEY_THINAP_MODE = "thinap-mode";
    public static final String KEY_PROTOCOL_TLS = "protocol-tls";
    public static final String KEY_OUTBOUND_MODE = "outbound-mode";
    public static final String KEY_APC_ADDRESS = "apc-address";
    public static final String KEY_APC_PORT = "apc-port";
    public static final String KEY_CONNECTION_URL = "connection-url";
    public static final String KEY_CHANNEL = "channel";
    public static final String KEY_RF_POWER_MODE = "rf-power-mode";
    public static final String KEY_WINDOW_SIZE = "window-size";
    public static final String KEY_COMPLIANT_MODE = "compliant-mode";
    public static final String KEY_INET_ADDRESS = "ip-address";
    public static final String KEY_MAC_ADDRESS = "mac-address";
    public static final String KEY_UUID = "uuid";
    public static final String KEY_ADAPTER_NAME = "adapter-name";
    public static final String KEY_ADAPTER_INTERFACE = "adapter-interface";
    public static final String KEY_SSL = "ssl";
    public static final String KEY_JAVA_RUNTIME_NAME = "java-runtime-name";
    public static final String KEY_JAVA_RUNTIME_VERSION = "java-runtime-version";
    public static final String KEY_JAVA_VM_NAME = "java-vm-name";
    public static final String KEY_JAVA_HOME = "java-home";
    public static final String KEY_OS_NAME = "os-name";
    public static final String KEY_OS_ARCH = "os-arch";
    public static final String KEY_OS_VERSION = "os-version";
    public static final String KEY_OS_DISTRIBUTION = "os-distribution";
    public static final String KEY_OS_TYPE = "os-type";
    public static final String KEY_AVAILABLE_PROCESSORS = "available-processors";
    public static final String KEY_THREAD_COUNT = "threads";
    public static final String KEY_MAX_MEMORY = "max-memory";
    public static final String KEY_FREE_MEMORY = "free-memory";
    public static final String KEY_TOTAL_MEMORY = "total-memory";
    public static final String KEY_USED_MEMORY = "used-memory";
    public static final String KEY_JAVA_GC = "java-gc";
    public static final String KEY_DEFAULT_ENCODING = "default-encoding";
    public static final String KEY_CWD = "cwd";
    public static final String KEY_INSTALLATION_PATH = "installation-path";
    public static final String KEY_LABEL_COUNT = "labels";
    public static final String KEY_ACCESS_POINT_COUNT = "access-points";
    public static final String KEY_ERROR_TASK_COUNT = "error-tasks";
    public static final String KEY_WAITING_TASK_COUNT = "waiting-tasks";
    public static final String KEY_SCHEDULED_TASKS = "scheduled-tasks";
    public static final String KEY_TASKS_COUNT = "tasks";
    public static final String KEY_TASKS_SIZE = "task-size";
    public static final String KEY_TASKS_SIZE_READABLE = "task-size-readable";
    public static final String KEY_REGISTERED_LABELS = "registered-labels";
    public static final String KEY_UART_ERRORS = "uart-errors";
    public static final String KEY_ROAMING_TABLE_VALID = "roaming-table-valid";
    public static final String KEY_ROAMING_TABLE_SIZE = "roaming-table-size";
    public static final String KEY_ROAMING_TABLE_UPDATE_TIME = "roaming-table-time";
    public static final String KEY_USED_CHANNELS = "used-channels";
    public static final String KEY_ROAMING_TABLE_VALID_TIME = "roaming-valid-time";
    public static final String KEY_PING_INTERVAL = "ping-interval";
    public static final String KEY_SYNC_PROFILE = "sync-profile";
    public static final String KEY_SERVICE_UPTIME = "service-uptime";
    public static final String KEY_AUTO_CONFIG = "auto-config";
    public static final String KEY_NETMASK = "netmask";
    public static final String KEY_BROADCAST = "broadcast";
    public static final String KEY_NAMESERVER1 = "nameserver1";
    public static final String KEY_NAMESERVER2 = "nameserver2";
    public static final String KEY_HARDWARE_REVISION = "hardware-revision";
    public static final String KEY_SERIAL = "serial";
    public static final String KEY_HOSTNAME = "hostname";
    public static final String KEY_SERVER_HOSTNAME = "server-hostname";
    public static final String KEY_SERVER_ADDRESS = "server-address";
    public static final String KEY_KERNEL_VERSION = "kernel-version";
    public static final String KEY_KERNEL_BUILD = "kernel-build";
    public static final String KEY_BOOTLOADER_VERSION = "bootloader-version";
    public static final String KEY_BOOTLOADER_BUILD = "bootloader-build";
    public static final String KEY_BUILD_SCRIPT_VERSION = "bootscript-version";
    public static final String KEY_BUILD_SCRIPT_BUILD = "bootscript-build";
    public static final String KEY_BUSYBOX_VERSION = "busybox-version";
    public static final String KEY_BIOS_VERSION = "bios-version";
    public static final String KEY_FORBID_JOIN = "forbid-join";
    public static final String KEY_SSL_HOSTNAME_VERIFICATION = "ssl-hostname-verification";
    public static final String KEY_SSL_STRICT_VERIFICATION = "ssl-strict-verification";
    public static final String KEY_SSL_CLIENT_CERTIFICATES = "ssl-verify-client-certificates";
    public static final String KEY_APPLIANCE_BUILD_NUMBER = "appliance-build-number";
    public static final String KEY_SERVER_TIME = "server-time";
    public static final String KEY_DATABASE_IDENTIFIER = "database-id";
    public static final String KEY_PROVISIONING_ENABLED = "provisioning-enabled";
    public static final String PLUGINS_LEVEL1 = "plugins-level1";
    public static final String PLUGINS_LEVEL2 = "plugins-level2";
    public static final String PLUGINS_LEVEL3 = "plugins-level3";
    public static final String KEY_TRANSMITTER_NAME = "transmitter-name";
    public static final String KEY_TRANSMITTER_FIRMWARE = "transmitter-firmware";
    public static final String KEY_TRANSMITTER_SERIAL = "transmitter-serial";
    public static final String KEY_RENDERING_ENGINE_NAME = "rendering-engine-name";
    public static final String KEY_RENDERING_ENGINE_VERSION = "rendering-engine-version";
    public static final String KEY_DAEMON_STATUS = "comm-daemon-status";
    public static final String KEY_DAEMON_VERSION = "comm-daemon-version";
    public static final String KEY_DAEMON_DEVICE_TYPE = "comm-daemon-device-type";
    public static final String KEY_DAEMON_REMOTE_ENDPOINT = "comm-daemon-remote-endpoint";
    public static final String KEY_DATABASE_SIZE_TOTAL = "db-size-total";
    public static final String KEY_DATABASE_SIZE_USED = "db-size-used";
    public static final String KEY_DATABASE_SIZE_FREEABLE = "db-size-freeable";
    public static final String KEY_DATABASE_PRODUCT_NAME = "db-product-name";
    public static final String KEY_DATABASE_PRODUCT_VERSION = "db-product-version";
    public static final String KEY_DATABASE_DRIVER_NAME = "db-driver-name";
    public static final String KEY_DATABASE_DRIVER_VERSION = "db-driver-version";
    public static final String KEY_DATABASE_URL = "db-url";
    public static final String PREFIX_SMART = "smart";
    public static final String KEY_SMART_TOOL_NAME = "tool-name";
    public static final String KEY_SMART_TOOL_VERSION = "tool-version";
    private final String serviceName;
    private final SortedMap<String, String> properties = new TreeMap<String, String>();
    private final SortedMap<String, Problem> problems = new TreeMap<String, Problem>();

    public ServiceStatus(ServiceStatus serviceStatus, boolean copyProblems) {
        this.serviceName = serviceStatus.getServiceName();
        for (Map.Entry<String, String> property : serviceStatus.properties.entrySet()) {
            this.setProperty(property.getKey(), property.getValue());
        }
        if (copyProblems) {
            for (Problem problem : serviceStatus.problems.values()) {
                this.addProblem(problem);
            }
        }
    }

    public ServiceStatus(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void setProperty(String key, DateTime value) {
        this.properties.put(key, value.toLocalDateTime().toString());
    }

    public void setProperty(String key, long value) {
        this.properties.put(key, Long.toString(value));
    }

    public void setProperty(String key, boolean value) {
        this.properties.put(key, Boolean.toString(value));
    }

    public String getPropertyValue(String key) {
        return (String)this.properties.get(key);
    }

    public long getNumericValue(String key) {
        return this.properties.get(key) != null ? Long.parseLong((String)this.properties.get(key)) : 0L;
    }

    public boolean getBooleanValue(String key) {
        return Boolean.parseBoolean((String)this.properties.get(key));
    }

    public Collection<Problem> getProblems() {
        return this.problems.values();
    }

    public void addProblem(Problem problem) {
        this.problems.put(problem.getIdentifier(), problem);
    }

    public void removeProblem(Problem problem) {
        this.removeProblem(problem.getIdentifier());
    }

    public void removeProblem(String problemIdentifier) {
        this.problems.remove(problemIdentifier);
    }

    public void clear() {
        this.properties.clear();
        this.problems.clear();
    }

    public Version getVersion() {
        String versionString = (String)this.properties.get(KEY_SOFTWARE_VERSION);
        String buildString = (String)this.properties.get(KEY_BUILD);
        if (Strings.isNullOrEmpty((String)versionString) || Strings.isNullOrEmpty((String)buildString)) {
            return null;
        }
        Version version = Version.fromString((String)versionString);
        int build = Integer.parseInt(buildString);
        return new Version(version, build);
    }
}

