/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;

public class ServiceAddress {
    public static ServiceAddress DEFAULT_INVALID = new ServiceAddress(false, "", 8080);
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 443;
    private final String protocol;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String path;

    public ServiceAddress(boolean ssl, String host, int port, String username, String password) {
        this(ssl, host, port, username, password, null);
    }

    public ServiceAddress(boolean ssl, String host, int port, String username, String password, String path) {
        this(ssl ? "https" : "http", host, port, username, password, path);
    }

    public ServiceAddress(String protocol, String host, int port, String username, String password) {
        this(protocol, host, port, username, password, null);
    }

    public ServiceAddress(String protocol, String host, int port, String username, String password, String path) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.path = path == null ? "" : (path.startsWith("/") ? path.substring(1) : path);
    }

    public ServiceAddress(boolean ssl, String host, int port) {
        this(ssl, host, port, null);
    }

    public ServiceAddress(boolean ssl, String host, int port, String path) {
        this(ssl ? "https" : "http", host, port, null, null, path);
    }

    public ServiceAddress(String protocol, String host, int port) {
        this(protocol, host, port, null, null, null);
    }

    public ServiceAddress(String protocol, String host, int port, String path) {
        this(protocol, host, port, null, null, path);
    }

    public boolean isValid() {
        return StringUtils.isNotEmpty((String)this.host);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean useSSL() {
        return this.protocol.equals("https");
    }

    public boolean hasCredentials() {
        return this.username != null && this.password != null;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPath() {
        return this.path;
    }

    public boolean hasPath() {
        return this.path != null && !this.path.isEmpty();
    }

    public String getConnectionString() {
        return String.format("%s://%s%s:%d/%s", this.getProtocol(), this.hasCredentials() ? String.format("%s:%s@", this.username, this.password) : "", this.host, this.port, this.path);
    }

    public String toString() {
        return String.format("%s://%s:%d/%s", this.getProtocol(), this.host, this.port, this.path);
    }

    public static ServiceAddress fromStringFor(String addressString, AccessPointType type) throws MalformedURLException {
        URL url = new URL(addressString);
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        String userInfo = url.getUserInfo();
        String path = url.getPath();
        String username = null;
        String password = null;
        if (host == null) {
            throw new MalformedURLException("Host is null");
        }
        if (port == -1) {
            port = type == AccessPointType.LANCOM ? AccessPointType.LANCOM.getDefaultPort() : ServiceAddress.getDefaultPortForProtocol(protocol);
        } else if (port < 0 || port > 65535) {
            throw new MalformedURLException("Illegal port (must be between 0 and 65535)");
        }
        if (!(protocol.equals("http") || protocol.equals("https") || protocol.equals("udp"))) {
            throw new MalformedURLException("Unsupported protocol (must be http, https, or udp)");
        }
        if (userInfo != null) {
            String[] splittedUserInfo = userInfo.split(":");
            username = splittedUserInfo[0];
            if (splittedUserInfo.length == 2) {
                password = splittedUserInfo[1];
            }
        }
        return new ServiceAddress(protocol, host, port, username, password, path);
    }

    public static ServiceAddress fromString(String addressString) throws MalformedURLException {
        return ServiceAddress.fromStringFor(addressString, AccessPointType.IMAGOTAG);
    }

    private static int getDefaultPortForProtocol(String protocol) throws MalformedURLException {
        if (protocol.equals("https")) {
            return 443;
        }
        if (protocol.equals("http")) {
            return 8080;
        }
        throw new MalformedURLException("Port not specified");
    }
}

