/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

public enum Page {
    PAGE_0(0),
    PAGE_1(1),
    PAGE_2(2),
    PAGE_3(3),
    PAGE_4(4),
    PAGE_5(5),
    PAGE_6(6),
    PAGE_7(7),
    PAGE_8(8),
    PAGE_9(9),
    PAGE_10(10),
    PAGE_11(11),
    PAGE_12(12),
    PAGE_13(13),
    PAGE_14(14),
    NO_PAGE(false, 15);

    public static final Page DEFAULT;
    public static final Page REGISTRATION;
    public static final Page RESET;
    public static final int MAX_SUPPORTED_PAGES = 15;
    private static final String NO_PAGE_STRING = "none";
    private boolean valid;
    private final int pageIndex;

    private Page(boolean valid, int page) {
        this.valid = valid;
        this.pageIndex = page;
    }

    private Page(int pageIndex) {
        this(true, pageIndex);
    }

    public static Page fromString(String pageString) throws NumberFormatException {
        if (pageString == null || pageString.isEmpty()) {
            return NO_PAGE;
        }
        if (pageString.equals(NO_PAGE_STRING)) {
            return NO_PAGE;
        }
        return Page.createValidPage(Integer.parseInt(pageString));
    }

    public static Page fromInteger(Integer pageIndex) {
        return pageIndex != null ? Page.valueOf(pageIndex) : null;
    }

    public static Page valueOf(int pageIndex) {
        if (pageIndex == Page.NO_PAGE.pageIndex) {
            return NO_PAGE;
        }
        return Page.createValidPage(pageIndex);
    }

    public static Page createValidPage(int pageIndex) {
        for (Page page : Page.values()) {
            if (page.pageIndex != pageIndex) continue;
            return page;
        }
        throw new IllegalArgumentException("Illegal page index");
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public String getPageString() {
        return this.valid ? Integer.toString(this.pageIndex) : NO_PAGE_STRING;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        return this.valid ? String.format("Page %s", this.pageIndex) : NO_PAGE_STRING;
    }

    public byte toByte() {
        return (byte)this.pageIndex;
    }

    static {
        DEFAULT = PAGE_0;
        REGISTRATION = PAGE_13;
        RESET = PAGE_14;
    }
}

