/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;

public enum OutputPower {
    A(15, 1, 0),
    B(7, -4, 1),
    C(5, -6, 2),
    D(1, -12, 3),
    E(13, 0, 4),
    F(10, -2, 5),
    G(3, -8, 6),
    H(2, -10, 7);

    public static final OutputPower DEFAULT_POWER;
    public static final OutputPower DEFAULT_MAX_POWER;
    private final int milliWatts;
    private final int dbm;
    private final int outputPowerSettingByte;

    private OutputPower(int milliWatts, int dbm, int outputPowerSettingByte) {
        this.milliWatts = milliWatts;
        this.dbm = dbm;
        this.outputPowerSettingByte = outputPowerSettingByte;
    }

    public int getMilliWatts() {
        return this.milliWatts;
    }

    public int getDbm() {
        return this.dbm;
    }

    public int getOutputPowerSettingByte() {
        return this.outputPowerSettingByte;
    }

    public String getDescription() {
        return String.format("%d mW", this.getMilliWatts());
    }

    public String getValue() {
        return String.format("%d", this.getMilliWatts());
    }

    public static String getPossibleOutputPowerSettings() {
        OutputPower[] settings = OutputPower.values();
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < settings.length; ++index) {
            sb.append(String.format("%s (%s)", settings[index].name(), settings[index].getDescription()));
            if (index == settings.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static Collection<OutputPower> getPossibleSettingsFor(final OutputPower outputPowerSetting) {
        return Collections2.filter((Collection)Lists.newArrayList((Object[])OutputPower.values()), (Predicate)new Predicate<OutputPower>(){

            public boolean apply(OutputPower setting) {
                return setting.getDbm() <= outputPowerSetting.getDbm();
            }
        });
    }

    static {
        DEFAULT_POWER = C;
        DEFAULT_MAX_POWER = A;
    }
}

